@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeSourceParametersSelfManagedKafkaParametersVpcArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property securityGroups List of security groups associated with the stream. These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.
 * @property subnets List of the subnets associated with the stream. These subnets must all be in the same VPC. You can specify as many as 16 subnets.
 */
public data class PipeSourceParametersSelfManagedKafkaParametersVpcArgs(
    public val securityGroups: Output<List<String>>? = null,
    public val subnets: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeSourceParametersSelfManagedKafkaParametersVpcArgs> {
    override fun toJava():
        com.pulumi.aws.pipes.inputs.PipeSourceParametersSelfManagedKafkaParametersVpcArgs =
        com.pulumi.aws.pipes.inputs.PipeSourceParametersSelfManagedKafkaParametersVpcArgs.builder()
            .securityGroups(securityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnets(subnets?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PipeSourceParametersSelfManagedKafkaParametersVpcArgs].
 */
@PulumiTagMarker
public class PipeSourceParametersSelfManagedKafkaParametersVpcArgsBuilder internal constructor() {
    private var securityGroups: Output<List<String>>? = null

    private var subnets: Output<List<String>>? = null

    /**
     * @param value List of security groups associated with the stream. These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.
     */
    @JvmName("nactwdjxrffgdpxy")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("apcyitefvcqweddy")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values List of security groups associated with the stream. These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.
     */
    @JvmName("wclpgrviofucovps")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value List of the subnets associated with the stream. These subnets must all be in the same VPC. You can specify as many as 16 subnets.
     */
    @JvmName("qpgismdmpomaifpg")
    public suspend fun subnets(`value`: Output<List<String>>) {
        this.subnets = value
    }

    @JvmName("ykwaclljmwcmknde")
    public suspend fun subnets(vararg values: Output<String>) {
        this.subnets = Output.all(values.asList())
    }

    /**
     * @param values List of the subnets associated with the stream. These subnets must all be in the same VPC. You can specify as many as 16 subnets.
     */
    @JvmName("fkkwcccuxonlffjk")
    public suspend fun subnets(values: List<Output<String>>) {
        this.subnets = Output.all(values)
    }

    /**
     * @param value List of security groups associated with the stream. These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.
     */
    @JvmName("njxurothihhtrtoy")
    public suspend fun securityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values List of security groups associated with the stream. These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.
     */
    @JvmName("njmjkussrgcqeyhv")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param value List of the subnets associated with the stream. These subnets must all be in the same VPC. You can specify as many as 16 subnets.
     */
    @JvmName("iyxviplxbytnlfvr")
    public suspend fun subnets(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param values List of the subnets associated with the stream. These subnets must all be in the same VPC. You can specify as many as 16 subnets.
     */
    @JvmName("ewbeqiirrunebmwm")
    public suspend fun subnets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    internal fun build(): PipeSourceParametersSelfManagedKafkaParametersVpcArgs =
        PipeSourceParametersSelfManagedKafkaParametersVpcArgs(
            securityGroups = securityGroups,
            subnets = subnets,
        )
}
