@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeTargetParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property batchJobParameters The parameters for using an AWS Batch job as a target. Detailed below.
 * @property cloudwatchLogsParameters The parameters for using an CloudWatch Logs log stream as a target. Detailed below.
 * @property ecsTaskParameters The parameters for using an Amazon ECS task as a target. Detailed below.
 * @property eventbridgeEventBusParameters The parameters for using an EventBridge event bus as a target. Detailed below.
 * @property httpParameters These are custom parameter to be used when the target is an API Gateway REST APIs or EventBridge ApiDestinations. Detailed below.
 * @property inputTemplate Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the target. Maximum length of 8192 characters.
 * @property kinesisStreamParameters The parameters for using a Kinesis stream as a source. Detailed below.
 * @property lambdaFunctionParameters The parameters for using a Lambda function as a target. Detailed below.
 * @property redshiftDataParameters These are custom parameters to be used when the target is a Amazon Redshift cluster to invoke the Amazon Redshift Data API BatchExecuteStatement. Detailed below.
 * @property sagemakerPipelineParameters The parameters for using a SageMaker pipeline as a target. Detailed below.
 * @property sqsQueueParameters The parameters for using a Amazon SQS stream as a target. Detailed below.
 * @property stepFunctionStateMachineParameters The parameters for using a Step Functions state machine as a target. Detailed below.
 */
public data class PipeTargetParametersArgs(
    public val batchJobParameters: Output<PipeTargetParametersBatchJobParametersArgs>? = null,
    public val cloudwatchLogsParameters: Output<PipeTargetParametersCloudwatchLogsParametersArgs>? =
        null,
    public val ecsTaskParameters: Output<PipeTargetParametersEcsTaskParametersArgs>? = null,
    public val eventbridgeEventBusParameters:
    Output<PipeTargetParametersEventbridgeEventBusParametersArgs>? = null,
    public val httpParameters: Output<PipeTargetParametersHttpParametersArgs>? = null,
    public val inputTemplate: Output<String>? = null,
    public val kinesisStreamParameters: Output<PipeTargetParametersKinesisStreamParametersArgs>? =
        null,
    public val lambdaFunctionParameters: Output<PipeTargetParametersLambdaFunctionParametersArgs>? =
        null,
    public val redshiftDataParameters: Output<PipeTargetParametersRedshiftDataParametersArgs>? = null,
    public val sagemakerPipelineParameters:
    Output<PipeTargetParametersSagemakerPipelineParametersArgs>? = null,
    public val sqsQueueParameters: Output<PipeTargetParametersSqsQueueParametersArgs>? = null,
    public val stepFunctionStateMachineParameters:
    Output<PipeTargetParametersStepFunctionStateMachineParametersArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeTargetParametersArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeTargetParametersArgs =
        com.pulumi.aws.pipes.inputs.PipeTargetParametersArgs.builder()
            .batchJobParameters(
                batchJobParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .cloudwatchLogsParameters(
                cloudwatchLogsParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .ecsTaskParameters(ecsTaskParameters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .eventbridgeEventBusParameters(
                eventbridgeEventBusParameters?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .httpParameters(httpParameters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .inputTemplate(inputTemplate?.applyValue({ args0 -> args0 }))
            .kinesisStreamParameters(
                kinesisStreamParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .lambdaFunctionParameters(
                lambdaFunctionParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .redshiftDataParameters(
                redshiftDataParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sagemakerPipelineParameters(
                sagemakerPipelineParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sqsQueueParameters(
                sqsQueueParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .stepFunctionStateMachineParameters(
                stepFunctionStateMachineParameters?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [PipeTargetParametersArgs].
 */
@PulumiTagMarker
public class PipeTargetParametersArgsBuilder internal constructor() {
    private var batchJobParameters: Output<PipeTargetParametersBatchJobParametersArgs>? = null

    private var cloudwatchLogsParameters: Output<PipeTargetParametersCloudwatchLogsParametersArgs>? =
        null

    private var ecsTaskParameters: Output<PipeTargetParametersEcsTaskParametersArgs>? = null

    private var eventbridgeEventBusParameters:
        Output<PipeTargetParametersEventbridgeEventBusParametersArgs>? = null

    private var httpParameters: Output<PipeTargetParametersHttpParametersArgs>? = null

    private var inputTemplate: Output<String>? = null

    private var kinesisStreamParameters: Output<PipeTargetParametersKinesisStreamParametersArgs>? =
        null

    private var lambdaFunctionParameters: Output<PipeTargetParametersLambdaFunctionParametersArgs>? =
        null

    private var redshiftDataParameters: Output<PipeTargetParametersRedshiftDataParametersArgs>? = null

    private var sagemakerPipelineParameters:
        Output<PipeTargetParametersSagemakerPipelineParametersArgs>? = null

    private var sqsQueueParameters: Output<PipeTargetParametersSqsQueueParametersArgs>? = null

    private var stepFunctionStateMachineParameters:
        Output<PipeTargetParametersStepFunctionStateMachineParametersArgs>? = null

    /**
     * @param value The parameters for using an AWS Batch job as a target. Detailed below.
     */
    @JvmName("iunhifefilascrdb")
    public suspend
    fun batchJobParameters(`value`: Output<PipeTargetParametersBatchJobParametersArgs>) {
        this.batchJobParameters = value
    }

    /**
     * @param value The parameters for using an CloudWatch Logs log stream as a target. Detailed below.
     */
    @JvmName("slraphnsqossapus")
    public suspend
    fun cloudwatchLogsParameters(`value`: Output<PipeTargetParametersCloudwatchLogsParametersArgs>) {
        this.cloudwatchLogsParameters = value
    }

    /**
     * @param value The parameters for using an Amazon ECS task as a target. Detailed below.
     */
    @JvmName("jrjhqliijrqjcsws")
    public suspend fun ecsTaskParameters(`value`: Output<PipeTargetParametersEcsTaskParametersArgs>) {
        this.ecsTaskParameters = value
    }

    /**
     * @param value The parameters for using an EventBridge event bus as a target. Detailed below.
     */
    @JvmName("jcjsburiuirinrbg")
    public suspend
    fun eventbridgeEventBusParameters(`value`: Output<PipeTargetParametersEventbridgeEventBusParametersArgs>) {
        this.eventbridgeEventBusParameters = value
    }

    /**
     * @param value These are custom parameter to be used when the target is an API Gateway REST APIs or EventBridge ApiDestinations. Detailed below.
     */
    @JvmName("lehpxtefwmqoucdt")
    public suspend fun httpParameters(`value`: Output<PipeTargetParametersHttpParametersArgs>) {
        this.httpParameters = value
    }

    /**
     * @param value Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the target. Maximum length of 8192 characters.
     */
    @JvmName("yfbbcpbyvmkrltrx")
    public suspend fun inputTemplate(`value`: Output<String>) {
        this.inputTemplate = value
    }

    /**
     * @param value The parameters for using a Kinesis stream as a source. Detailed below.
     */
    @JvmName("akqxwnrnlovbmqbf")
    public suspend
    fun kinesisStreamParameters(`value`: Output<PipeTargetParametersKinesisStreamParametersArgs>) {
        this.kinesisStreamParameters = value
    }

    /**
     * @param value The parameters for using a Lambda function as a target. Detailed below.
     */
    @JvmName("uqxedbgshkpfxmvu")
    public suspend
    fun lambdaFunctionParameters(`value`: Output<PipeTargetParametersLambdaFunctionParametersArgs>) {
        this.lambdaFunctionParameters = value
    }

    /**
     * @param value These are custom parameters to be used when the target is a Amazon Redshift cluster to invoke the Amazon Redshift Data API BatchExecuteStatement. Detailed below.
     */
    @JvmName("qnycwqfpfluptsjj")
    public suspend
    fun redshiftDataParameters(`value`: Output<PipeTargetParametersRedshiftDataParametersArgs>) {
        this.redshiftDataParameters = value
    }

    /**
     * @param value The parameters for using a SageMaker pipeline as a target. Detailed below.
     */
    @JvmName("hrgrcauderysjskw")
    public suspend
    fun sagemakerPipelineParameters(`value`: Output<PipeTargetParametersSagemakerPipelineParametersArgs>) {
        this.sagemakerPipelineParameters = value
    }

    /**
     * @param value The parameters for using a Amazon SQS stream as a target. Detailed below.
     */
    @JvmName("mbbnnennjoreicyy")
    public suspend
    fun sqsQueueParameters(`value`: Output<PipeTargetParametersSqsQueueParametersArgs>) {
        this.sqsQueueParameters = value
    }

    /**
     * @param value The parameters for using a Step Functions state machine as a target. Detailed below.
     */
    @JvmName("hrgmrkyroyvjwrww")
    public suspend
    fun stepFunctionStateMachineParameters(`value`: Output<PipeTargetParametersStepFunctionStateMachineParametersArgs>) {
        this.stepFunctionStateMachineParameters = value
    }

    /**
     * @param value The parameters for using an AWS Batch job as a target. Detailed below.
     */
    @JvmName("nehjswslrbheeyea")
    public suspend fun batchJobParameters(`value`: PipeTargetParametersBatchJobParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchJobParameters = mapped
    }

    /**
     * @param argument The parameters for using an AWS Batch job as a target. Detailed below.
     */
    @JvmName("dcxtlenhufiwectf")
    public suspend
    fun batchJobParameters(argument: suspend PipeTargetParametersBatchJobParametersArgsBuilder.() -> Unit) {
        val toBeMapped = PipeTargetParametersBatchJobParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.batchJobParameters = mapped
    }

    /**
     * @param value The parameters for using an CloudWatch Logs log stream as a target. Detailed below.
     */
    @JvmName("xrfwdgseddenhcid")
    public suspend
    fun cloudwatchLogsParameters(`value`: PipeTargetParametersCloudwatchLogsParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLogsParameters = mapped
    }

    /**
     * @param argument The parameters for using an CloudWatch Logs log stream as a target. Detailed below.
     */
    @JvmName("eqkwssqqqiecbfma")
    public suspend
    fun cloudwatchLogsParameters(argument: suspend PipeTargetParametersCloudwatchLogsParametersArgsBuilder.() -> Unit) {
        val toBeMapped = PipeTargetParametersCloudwatchLogsParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchLogsParameters = mapped
    }

    /**
     * @param value The parameters for using an Amazon ECS task as a target. Detailed below.
     */
    @JvmName("vgbdeoisrlfgiyha")
    public suspend fun ecsTaskParameters(`value`: PipeTargetParametersEcsTaskParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecsTaskParameters = mapped
    }

    /**
     * @param argument The parameters for using an Amazon ECS task as a target. Detailed below.
     */
    @JvmName("rirydtkvbxcdqngx")
    public suspend
    fun ecsTaskParameters(argument: suspend PipeTargetParametersEcsTaskParametersArgsBuilder.() -> Unit) {
        val toBeMapped = PipeTargetParametersEcsTaskParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.ecsTaskParameters = mapped
    }

    /**
     * @param value The parameters for using an EventBridge event bus as a target. Detailed below.
     */
    @JvmName("ntldtemsrrubbqug")
    public suspend
    fun eventbridgeEventBusParameters(`value`: PipeTargetParametersEventbridgeEventBusParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventbridgeEventBusParameters = mapped
    }

    /**
     * @param argument The parameters for using an EventBridge event bus as a target. Detailed below.
     */
    @JvmName("kxlfxhkybxigqbbi")
    public suspend
    fun eventbridgeEventBusParameters(argument: suspend PipeTargetParametersEventbridgeEventBusParametersArgsBuilder.() -> Unit) {
        val toBeMapped = PipeTargetParametersEventbridgeEventBusParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.eventbridgeEventBusParameters = mapped
    }

    /**
     * @param value These are custom parameter to be used when the target is an API Gateway REST APIs or EventBridge ApiDestinations. Detailed below.
     */
    @JvmName("ppefeflcqytoinqk")
    public suspend fun httpParameters(`value`: PipeTargetParametersHttpParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpParameters = mapped
    }

    /**
     * @param argument These are custom parameter to be used when the target is an API Gateway REST APIs or EventBridge ApiDestinations. Detailed below.
     */
    @JvmName("mdopxltukowqvbud")
    public suspend
    fun httpParameters(argument: suspend PipeTargetParametersHttpParametersArgsBuilder.() -> Unit) {
        val toBeMapped = PipeTargetParametersHttpParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.httpParameters = mapped
    }

    /**
     * @param value Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the target. Maximum length of 8192 characters.
     */
    @JvmName("oysoqaraluatvwmf")
    public suspend fun inputTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputTemplate = mapped
    }

    /**
     * @param value The parameters for using a Kinesis stream as a source. Detailed below.
     */
    @JvmName("npnvgtwcakxqcwxo")
    public suspend
    fun kinesisStreamParameters(`value`: PipeTargetParametersKinesisStreamParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kinesisStreamParameters = mapped
    }

    /**
     * @param argument The parameters for using a Kinesis stream as a source. Detailed below.
     */
    @JvmName("kuomqqaifmnkhour")
    public suspend
    fun kinesisStreamParameters(argument: suspend PipeTargetParametersKinesisStreamParametersArgsBuilder.() -> Unit) {
        val toBeMapped = PipeTargetParametersKinesisStreamParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.kinesisStreamParameters = mapped
    }

    /**
     * @param value The parameters for using a Lambda function as a target. Detailed below.
     */
    @JvmName("nfjmueiynqymxpur")
    public suspend
    fun lambdaFunctionParameters(`value`: PipeTargetParametersLambdaFunctionParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lambdaFunctionParameters = mapped
    }

    /**
     * @param argument The parameters for using a Lambda function as a target. Detailed below.
     */
    @JvmName("ewnfkwfafipmxnll")
    public suspend
    fun lambdaFunctionParameters(argument: suspend PipeTargetParametersLambdaFunctionParametersArgsBuilder.() -> Unit) {
        val toBeMapped = PipeTargetParametersLambdaFunctionParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.lambdaFunctionParameters = mapped
    }

    /**
     * @param value These are custom parameters to be used when the target is a Amazon Redshift cluster to invoke the Amazon Redshift Data API BatchExecuteStatement. Detailed below.
     */
    @JvmName("iqeafjicuqhhqglg")
    public suspend
    fun redshiftDataParameters(`value`: PipeTargetParametersRedshiftDataParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redshiftDataParameters = mapped
    }

    /**
     * @param argument These are custom parameters to be used when the target is a Amazon Redshift cluster to invoke the Amazon Redshift Data API BatchExecuteStatement. Detailed below.
     */
    @JvmName("vpfrjorvsevfqfxj")
    public suspend
    fun redshiftDataParameters(argument: suspend PipeTargetParametersRedshiftDataParametersArgsBuilder.() -> Unit) {
        val toBeMapped = PipeTargetParametersRedshiftDataParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.redshiftDataParameters = mapped
    }

    /**
     * @param value The parameters for using a SageMaker pipeline as a target. Detailed below.
     */
    @JvmName("qshspfipeqsdlwap")
    public suspend
    fun sagemakerPipelineParameters(`value`: PipeTargetParametersSagemakerPipelineParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sagemakerPipelineParameters = mapped
    }

    /**
     * @param argument The parameters for using a SageMaker pipeline as a target. Detailed below.
     */
    @JvmName("qclsftdncdulivoi")
    public suspend
    fun sagemakerPipelineParameters(argument: suspend PipeTargetParametersSagemakerPipelineParametersArgsBuilder.() -> Unit) {
        val toBeMapped = PipeTargetParametersSagemakerPipelineParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sagemakerPipelineParameters = mapped
    }

    /**
     * @param value The parameters for using a Amazon SQS stream as a target. Detailed below.
     */
    @JvmName("llymxkahlmkqbskp")
    public suspend fun sqsQueueParameters(`value`: PipeTargetParametersSqsQueueParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqsQueueParameters = mapped
    }

    /**
     * @param argument The parameters for using a Amazon SQS stream as a target. Detailed below.
     */
    @JvmName("tpinskriwnixmdtk")
    public suspend
    fun sqsQueueParameters(argument: suspend PipeTargetParametersSqsQueueParametersArgsBuilder.() -> Unit) {
        val toBeMapped = PipeTargetParametersSqsQueueParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sqsQueueParameters = mapped
    }

    /**
     * @param value The parameters for using a Step Functions state machine as a target. Detailed below.
     */
    @JvmName("kccxioihmcmqskyp")
    public suspend
    fun stepFunctionStateMachineParameters(`value`: PipeTargetParametersStepFunctionStateMachineParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stepFunctionStateMachineParameters = mapped
    }

    /**
     * @param argument The parameters for using a Step Functions state machine as a target. Detailed below.
     */
    @JvmName("racnsvabjgrersdq")
    public suspend
    fun stepFunctionStateMachineParameters(argument: suspend PipeTargetParametersStepFunctionStateMachineParametersArgsBuilder.() -> Unit) {
        val toBeMapped =
            PipeTargetParametersStepFunctionStateMachineParametersArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.stepFunctionStateMachineParameters = mapped
    }

    internal fun build(): PipeTargetParametersArgs = PipeTargetParametersArgs(
        batchJobParameters = batchJobParameters,
        cloudwatchLogsParameters = cloudwatchLogsParameters,
        ecsTaskParameters = ecsTaskParameters,
        eventbridgeEventBusParameters = eventbridgeEventBusParameters,
        httpParameters = httpParameters,
        inputTemplate = inputTemplate,
        kinesisStreamParameters = kinesisStreamParameters,
        lambdaFunctionParameters = lambdaFunctionParameters,
        redshiftDataParameters = redshiftDataParameters,
        sagemakerPipelineParameters = sagemakerPipelineParameters,
        sqsQueueParameters = sqsQueueParameters,
        stepFunctionStateMachineParameters = stepFunctionStateMachineParameters,
    )
}
