@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeTargetParametersBatchJobParametersArrayPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property size The size of the array, if this is an array batch job. Minimum value of 2. Maximum value of 10,000.
 */
public data class PipeTargetParametersBatchJobParametersArrayPropertiesArgs(
    public val size: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeTargetParametersBatchJobParametersArrayPropertiesArgs> {
    override fun toJava():
        com.pulumi.aws.pipes.inputs.PipeTargetParametersBatchJobParametersArrayPropertiesArgs =
        com.pulumi.aws.pipes.inputs.PipeTargetParametersBatchJobParametersArrayPropertiesArgs.builder()
            .size(size?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeTargetParametersBatchJobParametersArrayPropertiesArgs].
 */
@PulumiTagMarker
public class PipeTargetParametersBatchJobParametersArrayPropertiesArgsBuilder internal constructor() {
    private var size: Output<Int>? = null

    /**
     * @param value The size of the array, if this is an array batch job. Minimum value of 2. Maximum value of 10,000.
     */
    @JvmName("tdanabpxcvcwirvx")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value The size of the array, if this is an array batch job. Minimum value of 2. Maximum value of 10,000.
     */
    @JvmName("bwwhhgteumxghnvr")
    public suspend fun size(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    internal fun build(): PipeTargetParametersBatchJobParametersArrayPropertiesArgs =
        PipeTargetParametersBatchJobParametersArrayPropertiesArgs(
            size = size,
        )
}
