@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeTargetParametersBatchJobParametersContainerOverridesResourceRequirementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property type The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task). Valid Values: random, spread, binpack.
 * @property value Value of parameter to start execution of a SageMaker Model Building Pipeline. Maximum length of 1024.
 */
public data class PipeTargetParametersBatchJobParametersContainerOverridesResourceRequirementArgs(
    public val type: Output<String>,
    public val `value`: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeTargetParametersBatchJobParametersContainerOverridesResourceRequirementArgs> {
    override fun toJava():
        com.pulumi.aws.pipes.inputs.PipeTargetParametersBatchJobParametersContainerOverridesResourceRequirementArgs =
        com.pulumi.aws.pipes.inputs.PipeTargetParametersBatchJobParametersContainerOverridesResourceRequirementArgs.builder()
            .type(type.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeTargetParametersBatchJobParametersContainerOverridesResourceRequirementArgs].
 */
@PulumiTagMarker
public class PipeTargetParametersBatchJobParametersContainerOverridesResourceRequirementArgsBuilder
internal constructor() {
    private var type: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task). Valid Values: random, spread, binpack.
     */
    @JvmName("cjrkqhdahyveomoo")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Value of parameter to start execution of a SageMaker Model Building Pipeline. Maximum length of 1024.
     */
    @JvmName("pxaplymvqphvpyda")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task). Valid Values: random, spread, binpack.
     */
    @JvmName("yocntlxcmovxmjfq")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Value of parameter to start execution of a SageMaker Model Building Pipeline. Maximum length of 1024.
     */
    @JvmName("tjajdmomsqusngvv")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build():
        PipeTargetParametersBatchJobParametersContainerOverridesResourceRequirementArgs =
        PipeTargetParametersBatchJobParametersContainerOverridesResourceRequirementArgs(
            type = type ?: throw PulumiNullFieldException("type"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
