@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeTargetParametersBatchJobParametersDependsOnArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property jobId The job ID of the AWS Batch job that's associated with this dependency.
 * @property type The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task). Valid Values: random, spread, binpack.
 */
public data class PipeTargetParametersBatchJobParametersDependsOnArgs(
    public val jobId: Output<String>? = null,
    public val type: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeTargetParametersBatchJobParametersDependsOnArgs> {
    override fun toJava():
        com.pulumi.aws.pipes.inputs.PipeTargetParametersBatchJobParametersDependsOnArgs =
        com.pulumi.aws.pipes.inputs.PipeTargetParametersBatchJobParametersDependsOnArgs.builder()
            .jobId(jobId?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeTargetParametersBatchJobParametersDependsOnArgs].
 */
@PulumiTagMarker
public class PipeTargetParametersBatchJobParametersDependsOnArgsBuilder internal constructor() {
    private var jobId: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The job ID of the AWS Batch job that's associated with this dependency.
     */
    @JvmName("bwskdtbnfaounirh")
    public suspend fun jobId(`value`: Output<String>) {
        this.jobId = value
    }

    /**
     * @param value The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task). Valid Values: random, spread, binpack.
     */
    @JvmName("prrxrpjqnyjwmgbo")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The job ID of the AWS Batch job that's associated with this dependency.
     */
    @JvmName("kfssobbskichquxy")
    public suspend fun jobId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobId = mapped
    }

    /**
     * @param value The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task). Valid Values: random, spread, binpack.
     */
    @JvmName("aegeysrxsoujqicd")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): PipeTargetParametersBatchJobParametersDependsOnArgs =
        PipeTargetParametersBatchJobParametersDependsOnArgs(
            jobId = jobId,
            type = type,
        )
}
