@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeTargetParametersBatchJobParametersRetryStrategyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property attempts The number of times to move a job to the RUNNABLE status. If the value of attempts is greater than one, the job is retried on failure the same number of attempts as the value. Maximum value of 10.
 */
public data class PipeTargetParametersBatchJobParametersRetryStrategyArgs(
    public val attempts: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeTargetParametersBatchJobParametersRetryStrategyArgs> {
    override fun toJava():
        com.pulumi.aws.pipes.inputs.PipeTargetParametersBatchJobParametersRetryStrategyArgs =
        com.pulumi.aws.pipes.inputs.PipeTargetParametersBatchJobParametersRetryStrategyArgs.builder()
            .attempts(attempts?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeTargetParametersBatchJobParametersRetryStrategyArgs].
 */
@PulumiTagMarker
public class PipeTargetParametersBatchJobParametersRetryStrategyArgsBuilder internal constructor() {
    private var attempts: Output<Int>? = null

    /**
     * @param value The number of times to move a job to the RUNNABLE status. If the value of attempts is greater than one, the job is retried on failure the same number of attempts as the value. Maximum value of 10.
     */
    @JvmName("vgtdgqhfxfjqkyty")
    public suspend fun attempts(`value`: Output<Int>) {
        this.attempts = value
    }

    /**
     * @param value The number of times to move a job to the RUNNABLE status. If the value of attempts is greater than one, the job is retried on failure the same number of attempts as the value. Maximum value of 10.
     */
    @JvmName("hciknnujbbwfspwd")
    public suspend fun attempts(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attempts = mapped
    }

    internal fun build(): PipeTargetParametersBatchJobParametersRetryStrategyArgs =
        PipeTargetParametersBatchJobParametersRetryStrategyArgs(
            attempts = attempts,
        )
}
