@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersNetworkConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property awsVpcConfiguration Use this structure to specify the VPC subnets and security groups for the task, and whether a public IP address is to be used. This structure is relevant only for ECS tasks that use the awsvpc network mode. Detailed below.
 */
public data class PipeTargetParametersEcsTaskParametersNetworkConfigurationArgs(
    public val awsVpcConfiguration:
    Output<PipeTargetParametersEcsTaskParametersNetworkConfigurationAwsVpcConfigurationArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersNetworkConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersNetworkConfigurationArgs =
        com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersNetworkConfigurationArgs.builder()
            .awsVpcConfiguration(
                awsVpcConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [PipeTargetParametersEcsTaskParametersNetworkConfigurationArgs].
 */
@PulumiTagMarker
public class PipeTargetParametersEcsTaskParametersNetworkConfigurationArgsBuilder internal
constructor() {
    private var awsVpcConfiguration:
        Output<PipeTargetParametersEcsTaskParametersNetworkConfigurationAwsVpcConfigurationArgs>? =
        null

    /**
     * @param value Use this structure to specify the VPC subnets and security groups for the task, and whether a public IP address is to be used. This structure is relevant only for ECS tasks that use the awsvpc network mode. Detailed below.
     */
    @JvmName("mwxeaiiakwnvbnys")
    public suspend
    fun awsVpcConfiguration(`value`: Output<PipeTargetParametersEcsTaskParametersNetworkConfigurationAwsVpcConfigurationArgs>) {
        this.awsVpcConfiguration = value
    }

    /**
     * @param value Use this structure to specify the VPC subnets and security groups for the task, and whether a public IP address is to be used. This structure is relevant only for ECS tasks that use the awsvpc network mode. Detailed below.
     */
    @JvmName("kfkhsiingrdiwmxk")
    public suspend
    fun awsVpcConfiguration(`value`: PipeTargetParametersEcsTaskParametersNetworkConfigurationAwsVpcConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsVpcConfiguration = mapped
    }

    /**
     * @param argument Use this structure to specify the VPC subnets and security groups for the task, and whether a public IP address is to be used. This structure is relevant only for ECS tasks that use the awsvpc network mode. Detailed below.
     */
    @JvmName("lanmpjckqvxepqxx")
    public suspend
    fun awsVpcConfiguration(argument: suspend PipeTargetParametersEcsTaskParametersNetworkConfigurationAwsVpcConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            PipeTargetParametersEcsTaskParametersNetworkConfigurationAwsVpcConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.awsVpcConfiguration = mapped
    }

    internal fun build(): PipeTargetParametersEcsTaskParametersNetworkConfigurationArgs =
        PipeTargetParametersEcsTaskParametersNetworkConfigurationArgs(
            awsVpcConfiguration = awsVpcConfiguration,
        )
}
