@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersNetworkConfigurationAwsVpcConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property assignPublicIp Specifies whether the task's elastic network interface receives a public IP address. You can specify ENABLED only when LaunchType in EcsParameters is set to FARGATE. Valid Values: ENABLED, DISABLED.
 * @property securityGroups List of security groups associated with the stream. These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.
 * @property subnets List of the subnets associated with the stream. These subnets must all be in the same VPC. You can specify as many as 16 subnets.
 */
public data class PipeTargetParametersEcsTaskParametersNetworkConfigurationAwsVpcConfigurationArgs(
    public val assignPublicIp: Output<String>? = null,
    public val securityGroups: Output<List<String>>? = null,
    public val subnets: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersNetworkConfigurationAwsVpcConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersNetworkConfigurationAwsVpcConfigurationArgs =
        com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersNetworkConfigurationAwsVpcConfigurationArgs.builder()
            .assignPublicIp(assignPublicIp?.applyValue({ args0 -> args0 }))
            .securityGroups(securityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnets(subnets?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PipeTargetParametersEcsTaskParametersNetworkConfigurationAwsVpcConfigurationArgs].
 */
@PulumiTagMarker
public class PipeTargetParametersEcsTaskParametersNetworkConfigurationAwsVpcConfigurationArgsBuilder
internal constructor() {
    private var assignPublicIp: Output<String>? = null

    private var securityGroups: Output<List<String>>? = null

    private var subnets: Output<List<String>>? = null

    /**
     * @param value Specifies whether the task's elastic network interface receives a public IP address. You can specify ENABLED only when LaunchType in EcsParameters is set to FARGATE. Valid Values: ENABLED, DISABLED.
     */
    @JvmName("qoixdylhtvkcrxhr")
    public suspend fun assignPublicIp(`value`: Output<String>) {
        this.assignPublicIp = value
    }

    /**
     * @param value List of security groups associated with the stream. These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.
     */
    @JvmName("nijmljspspvwkxft")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("shabsxealrpcsakb")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values List of security groups associated with the stream. These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.
     */
    @JvmName("baejyxgnithsbpif")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value List of the subnets associated with the stream. These subnets must all be in the same VPC. You can specify as many as 16 subnets.
     */
    @JvmName("rkkdwkdphbmhvous")
    public suspend fun subnets(`value`: Output<List<String>>) {
        this.subnets = value
    }

    @JvmName("advisoqyseiyxhre")
    public suspend fun subnets(vararg values: Output<String>) {
        this.subnets = Output.all(values.asList())
    }

    /**
     * @param values List of the subnets associated with the stream. These subnets must all be in the same VPC. You can specify as many as 16 subnets.
     */
    @JvmName("hgyumkyulrrvaxrn")
    public suspend fun subnets(values: List<Output<String>>) {
        this.subnets = Output.all(values)
    }

    /**
     * @param value Specifies whether the task's elastic network interface receives a public IP address. You can specify ENABLED only when LaunchType in EcsParameters is set to FARGATE. Valid Values: ENABLED, DISABLED.
     */
    @JvmName("bifwbdoetjqutfts")
    public suspend fun assignPublicIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assignPublicIp = mapped
    }

    /**
     * @param value List of security groups associated with the stream. These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.
     */
    @JvmName("wpjkobjoljtckaxj")
    public suspend fun securityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values List of security groups associated with the stream. These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.
     */
    @JvmName("nymnbjbrowpjdxmm")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param value List of the subnets associated with the stream. These subnets must all be in the same VPC. You can specify as many as 16 subnets.
     */
    @JvmName("ygvigggvboxgiiuq")
    public suspend fun subnets(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param values List of the subnets associated with the stream. These subnets must all be in the same VPC. You can specify as many as 16 subnets.
     */
    @JvmName("bbcododptwysshcm")
    public suspend fun subnets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    internal fun build():
        PipeTargetParametersEcsTaskParametersNetworkConfigurationAwsVpcConfigurationArgs =
        PipeTargetParametersEcsTaskParametersNetworkConfigurationAwsVpcConfigurationArgs(
            assignPublicIp = assignPublicIp,
            securityGroups = securityGroups,
            subnets = subnets,
        )
}
