@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersOverridesContainerOverrideArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property commands List of commands to send to the container that overrides the default command from the Docker image or the task definition. You must also specify a container name.
 * @property cpu The number of cpu units reserved for the container, instead of the default value from the task definition. You must also specify a container name.
 * @property environmentFiles A list of files containing the environment variables to pass to a container, instead of the value from the container definition. Detailed below.
 * @property environments The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name. Detailed below.
 * @property memory The hard limit (in MiB) of memory to present to the container, instead of the default value from the task definition. If your container attempts to exceed the memory specified here, the container is killed. You must also specify a container name.
 * @property memoryReservation The soft limit (in MiB) of memory to reserve for the container, instead of the default value from the task definition. You must also specify a container name.
 * @property name Name of the pipe. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
 * @property resourceRequirements The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. Detailed below.
 */
public data class PipeTargetParametersEcsTaskParametersOverridesContainerOverrideArgs(
    public val commands: Output<List<String>>? = null,
    public val cpu: Output<Int>? = null,
    public val environmentFiles:
    Output<List<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFileArgs>>? =
        null,
    public val environments:
    Output<List<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgs>>? =
        null,
    public val memory: Output<Int>? = null,
    public val memoryReservation: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val resourceRequirements:
    Output<List<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirementArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersOverridesContainerOverrideArgs> {
    override fun toJava():
        com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersOverridesContainerOverrideArgs =
        com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersOverridesContainerOverrideArgs.builder()
            .commands(commands?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .cpu(cpu?.applyValue({ args0 -> args0 }))
            .environmentFiles(
                environmentFiles?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .environments(
                environments?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .memory(memory?.applyValue({ args0 -> args0 }))
            .memoryReservation(memoryReservation?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceRequirements(
                resourceRequirements?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [PipeTargetParametersEcsTaskParametersOverridesContainerOverrideArgs].
 */
@PulumiTagMarker
public class PipeTargetParametersEcsTaskParametersOverridesContainerOverrideArgsBuilder internal
constructor() {
    private var commands: Output<List<String>>? = null

    private var cpu: Output<Int>? = null

    private var environmentFiles:
        Output<List<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFileArgs>>? =
        null

    private var environments:
        Output<List<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgs>>? =
        null

    private var memory: Output<Int>? = null

    private var memoryReservation: Output<Int>? = null

    private var name: Output<String>? = null

    private var resourceRequirements:
        Output<List<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirementArgs>>? =
        null

    /**
     * @param value List of commands to send to the container that overrides the default command from the Docker image or the task definition. You must also specify a container name.
     */
    @JvmName("lqjibbtgjoresstm")
    public suspend fun commands(`value`: Output<List<String>>) {
        this.commands = value
    }

    @JvmName("hrkykrxhhucdocog")
    public suspend fun commands(vararg values: Output<String>) {
        this.commands = Output.all(values.asList())
    }

    /**
     * @param values List of commands to send to the container that overrides the default command from the Docker image or the task definition. You must also specify a container name.
     */
    @JvmName("rjhqyvvfxtlfajgy")
    public suspend fun commands(values: List<Output<String>>) {
        this.commands = Output.all(values)
    }

    /**
     * @param value The number of cpu units reserved for the container, instead of the default value from the task definition. You must also specify a container name.
     */
    @JvmName("doafgdexrkpdekuf")
    public suspend fun cpu(`value`: Output<Int>) {
        this.cpu = value
    }

    /**
     * @param value A list of files containing the environment variables to pass to a container, instead of the value from the container definition. Detailed below.
     */
    @JvmName("paincodulxxifjvo")
    public suspend
    fun environmentFiles(`value`: Output<List<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFileArgs>>) {
        this.environmentFiles = value
    }

    @JvmName("xsgydxqdwoswyseh")
    public suspend fun environmentFiles(
        vararg
        values: Output<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFileArgs>,
    ) {
        this.environmentFiles = Output.all(values.asList())
    }

    /**
     * @param values A list of files containing the environment variables to pass to a container, instead of the value from the container definition. Detailed below.
     */
    @JvmName("qeqxtdywlnfjjqac")
    public suspend
    fun environmentFiles(values: List<Output<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFileArgs>>) {
        this.environmentFiles = Output.all(values)
    }

    /**
     * @param value The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name. Detailed below.
     */
    @JvmName("tqqbxaaknjpfqugr")
    public suspend
    fun environments(`value`: Output<List<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgs>>) {
        this.environments = value
    }

    @JvmName("xasejcngwevaukmn")
    public suspend fun environments(
        vararg
        values: Output<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgs>,
    ) {
        this.environments = Output.all(values.asList())
    }

    /**
     * @param values The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name. Detailed below.
     */
    @JvmName("irytcwsyhjdslvuw")
    public suspend
    fun environments(values: List<Output<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgs>>) {
        this.environments = Output.all(values)
    }

    /**
     * @param value The hard limit (in MiB) of memory to present to the container, instead of the default value from the task definition. If your container attempts to exceed the memory specified here, the container is killed. You must also specify a container name.
     */
    @JvmName("gwfhlourodkisejq")
    public suspend fun memory(`value`: Output<Int>) {
        this.memory = value
    }

    /**
     * @param value The soft limit (in MiB) of memory to reserve for the container, instead of the default value from the task definition. You must also specify a container name.
     */
    @JvmName("dpuocghfakswikxd")
    public suspend fun memoryReservation(`value`: Output<Int>) {
        this.memoryReservation = value
    }

    /**
     * @param value Name of the pipe. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("oxseptpruxainadt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. Detailed below.
     */
    @JvmName("jqululdqcoametph")
    public suspend
    fun resourceRequirements(`value`: Output<List<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirementArgs>>) {
        this.resourceRequirements = value
    }

    @JvmName("jlbbxgucqetroyfk")
    public suspend fun resourceRequirements(
        vararg
        values: Output<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirementArgs>,
    ) {
        this.resourceRequirements = Output.all(values.asList())
    }

    /**
     * @param values The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. Detailed below.
     */
    @JvmName("vowlbovdecukeslb")
    public suspend
    fun resourceRequirements(values: List<Output<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirementArgs>>) {
        this.resourceRequirements = Output.all(values)
    }

    /**
     * @param value List of commands to send to the container that overrides the default command from the Docker image or the task definition. You must also specify a container name.
     */
    @JvmName("ptntpsdewqklkhjh")
    public suspend fun commands(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commands = mapped
    }

    /**
     * @param values List of commands to send to the container that overrides the default command from the Docker image or the task definition. You must also specify a container name.
     */
    @JvmName("pmvgswjvmuvvnmyp")
    public suspend fun commands(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.commands = mapped
    }

    /**
     * @param value The number of cpu units reserved for the container, instead of the default value from the task definition. You must also specify a container name.
     */
    @JvmName("fktplhxdjgviwpew")
    public suspend fun cpu(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpu = mapped
    }

    /**
     * @param value A list of files containing the environment variables to pass to a container, instead of the value from the container definition. Detailed below.
     */
    @JvmName("xflodalvrnhtapcm")
    public suspend
    fun environmentFiles(`value`: List<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFileArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentFiles = mapped
    }

    /**
     * @param argument A list of files containing the environment variables to pass to a container, instead of the value from the container definition. Detailed below.
     */
    @JvmName("nywokoxsgucsivhp")
    public suspend
    fun environmentFiles(argument: List<suspend PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFileArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFileArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentFiles = mapped
    }

    /**
     * @param argument A list of files containing the environment variables to pass to a container, instead of the value from the container definition. Detailed below.
     */
    @JvmName("vuvhjaoderpbggkp")
    public suspend fun environmentFiles(
        vararg
        argument: suspend PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFileArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFileArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentFiles = mapped
    }

    /**
     * @param argument A list of files containing the environment variables to pass to a container, instead of the value from the container definition. Detailed below.
     */
    @JvmName("mrfajbgdxrnbdlct")
    public suspend
    fun environmentFiles(argument: suspend PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFileArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFileArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.environmentFiles = mapped
    }

    /**
     * @param values A list of files containing the environment variables to pass to a container, instead of the value from the container definition. Detailed below.
     */
    @JvmName("hyumgwkvfsnjxjsj")
    public suspend fun environmentFiles(
        vararg
        values: PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFileArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentFiles = mapped
    }

    /**
     * @param value The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name. Detailed below.
     */
    @JvmName("yjguvordtfaecuau")
    public suspend
    fun environments(`value`: List<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environments = mapped
    }

    /**
     * @param argument The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name. Detailed below.
     */
    @JvmName("rsvtkbqberhgilxv")
    public suspend
    fun environments(argument: List<suspend PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.environments = mapped
    }

    /**
     * @param argument The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name. Detailed below.
     */
    @JvmName("nkttafmlodteywby")
    public suspend fun environments(
        vararg
        argument: suspend PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.environments = mapped
    }

    /**
     * @param argument The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name. Detailed below.
     */
    @JvmName("vvvymnhxrueppxek")
    public suspend
    fun environments(argument: suspend PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.environments = mapped
    }

    /**
     * @param values The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name. Detailed below.
     */
    @JvmName("cyeydsfabvufvkcp")
    public suspend fun environments(
        vararg
        values: PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environments = mapped
    }

    /**
     * @param value The hard limit (in MiB) of memory to present to the container, instead of the default value from the task definition. If your container attempts to exceed the memory specified here, the container is killed. You must also specify a container name.
     */
    @JvmName("oosyiarwlietttue")
    public suspend fun memory(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memory = mapped
    }

    /**
     * @param value The soft limit (in MiB) of memory to reserve for the container, instead of the default value from the task definition. You must also specify a container name.
     */
    @JvmName("vuhuulaitukpqurh")
    public suspend fun memoryReservation(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memoryReservation = mapped
    }

    /**
     * @param value Name of the pipe. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("dtnnhahlvrvqgmxc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. Detailed below.
     */
    @JvmName("ixphjtrpppdyhuop")
    public suspend
    fun resourceRequirements(`value`: List<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirementArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceRequirements = mapped
    }

    /**
     * @param argument The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. Detailed below.
     */
    @JvmName("knylbimiggebvgpl")
    public suspend
    fun resourceRequirements(argument: List<suspend PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirementArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirementArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceRequirements = mapped
    }

    /**
     * @param argument The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. Detailed below.
     */
    @JvmName("svkhsxowikckgwvb")
    public suspend fun resourceRequirements(
        vararg
        argument: suspend PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirementArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirementArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceRequirements = mapped
    }

    /**
     * @param argument The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. Detailed below.
     */
    @JvmName("kgrsthnxujtegdam")
    public suspend
    fun resourceRequirements(argument: suspend PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirementArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirementArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.resourceRequirements = mapped
    }

    /**
     * @param values The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. Detailed below.
     */
    @JvmName("lilvseqdffpqlvts")
    public suspend fun resourceRequirements(
        vararg
        values: PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirementArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceRequirements = mapped
    }

    internal fun build(): PipeTargetParametersEcsTaskParametersOverridesContainerOverrideArgs =
        PipeTargetParametersEcsTaskParametersOverridesContainerOverrideArgs(
            commands = commands,
            cpu = cpu,
            environmentFiles = environmentFiles,
            environments = environments,
            memory = memory,
            memoryReservation = memoryReservation,
            name = name,
            resourceRequirements = resourceRequirements,
        )
}
