@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersPlacementConstraintArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expression A cluster query language expression to apply to the constraint. You cannot specify an expression if the constraint type is distinctInstance. Maximum length of 2,000.
 * @property type The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task). Valid Values: random, spread, binpack.
 */
public data class PipeTargetParametersEcsTaskParametersPlacementConstraintArgs(
    public val expression: Output<String>? = null,
    public val type: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersPlacementConstraintArgs> {
    override fun toJava():
        com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersPlacementConstraintArgs =
        com.pulumi.aws.pipes.inputs.PipeTargetParametersEcsTaskParametersPlacementConstraintArgs.builder()
            .expression(expression?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeTargetParametersEcsTaskParametersPlacementConstraintArgs].
 */
@PulumiTagMarker
public class PipeTargetParametersEcsTaskParametersPlacementConstraintArgsBuilder internal
constructor() {
    private var expression: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value A cluster query language expression to apply to the constraint. You cannot specify an expression if the constraint type is distinctInstance. Maximum length of 2,000.
     */
    @JvmName("ybdrxfbrrbckdbih")
    public suspend fun expression(`value`: Output<String>) {
        this.expression = value
    }

    /**
     * @param value The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task). Valid Values: random, spread, binpack.
     */
    @JvmName("qouhutbwgojrfsla")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value A cluster query language expression to apply to the constraint. You cannot specify an expression if the constraint type is distinctInstance. Maximum length of 2,000.
     */
    @JvmName("btbncjpglweiclnx")
    public suspend fun expression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expression = mapped
    }

    /**
     * @param value The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task). Valid Values: random, spread, binpack.
     */
    @JvmName("rhvybnmhnewchgrf")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): PipeTargetParametersEcsTaskParametersPlacementConstraintArgs =
        PipeTargetParametersEcsTaskParametersPlacementConstraintArgs(
            expression = expression,
            type = type,
        )
}
