@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeTargetParametersEventbridgeEventBusParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property detailType A free-form string, with a maximum of 128 characters, used to decide what fields to expect in the event detail.
 * @property endpointId The URL subdomain of the endpoint. For example, if the URL for Endpoint is https://abcde.veo.endpoints.event.amazonaws.com, then the EndpointId is abcde.veo.
 * @property resources List of AWS resources, identified by Amazon Resource Name (ARN), which the event primarily concerns. Any number, including zero, may be present.
 * @property source Source resource of the pipe (typically an ARN).
 * @property time The time stamp of the event, per RFC3339. If no time stamp is provided, the time stamp of the PutEvents call is used. This is the JSON path to the field in the event e.g. $.detail.timestamp
 */
public data class PipeTargetParametersEventbridgeEventBusParametersArgs(
    public val detailType: Output<String>? = null,
    public val endpointId: Output<String>? = null,
    public val resources: Output<List<String>>? = null,
    public val source: Output<String>? = null,
    public val time: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeTargetParametersEventbridgeEventBusParametersArgs> {
    override fun toJava():
        com.pulumi.aws.pipes.inputs.PipeTargetParametersEventbridgeEventBusParametersArgs =
        com.pulumi.aws.pipes.inputs.PipeTargetParametersEventbridgeEventBusParametersArgs.builder()
            .detailType(detailType?.applyValue({ args0 -> args0 }))
            .endpointId(endpointId?.applyValue({ args0 -> args0 }))
            .resources(resources?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .source(source?.applyValue({ args0 -> args0 }))
            .time(time?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeTargetParametersEventbridgeEventBusParametersArgs].
 */
@PulumiTagMarker
public class PipeTargetParametersEventbridgeEventBusParametersArgsBuilder internal constructor() {
    private var detailType: Output<String>? = null

    private var endpointId: Output<String>? = null

    private var resources: Output<List<String>>? = null

    private var source: Output<String>? = null

    private var time: Output<String>? = null

    /**
     * @param value A free-form string, with a maximum of 128 characters, used to decide what fields to expect in the event detail.
     */
    @JvmName("jcvsvkgcioevucrx")
    public suspend fun detailType(`value`: Output<String>) {
        this.detailType = value
    }

    /**
     * @param value The URL subdomain of the endpoint. For example, if the URL for Endpoint is https://abcde.veo.endpoints.event.amazonaws.com, then the EndpointId is abcde.veo.
     */
    @JvmName("ohmtjjqwswpexfgv")
    public suspend fun endpointId(`value`: Output<String>) {
        this.endpointId = value
    }

    /**
     * @param value List of AWS resources, identified by Amazon Resource Name (ARN), which the event primarily concerns. Any number, including zero, may be present.
     */
    @JvmName("sgnqwbtxjaakcubn")
    public suspend fun resources(`value`: Output<List<String>>) {
        this.resources = value
    }

    @JvmName("egcufypjeresxcxw")
    public suspend fun resources(vararg values: Output<String>) {
        this.resources = Output.all(values.asList())
    }

    /**
     * @param values List of AWS resources, identified by Amazon Resource Name (ARN), which the event primarily concerns. Any number, including zero, may be present.
     */
    @JvmName("khbmhcfbdblmnvhq")
    public suspend fun resources(values: List<Output<String>>) {
        this.resources = Output.all(values)
    }

    /**
     * @param value Source resource of the pipe (typically an ARN).
     */
    @JvmName("qrtartlepjltsodf")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value The time stamp of the event, per RFC3339. If no time stamp is provided, the time stamp of the PutEvents call is used. This is the JSON path to the field in the event e.g. $.detail.timestamp
     */
    @JvmName("lrkukpcblpjcqnmg")
    public suspend fun time(`value`: Output<String>) {
        this.time = value
    }

    /**
     * @param value A free-form string, with a maximum of 128 characters, used to decide what fields to expect in the event detail.
     */
    @JvmName("orbgnfecaaelivnf")
    public suspend fun detailType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detailType = mapped
    }

    /**
     * @param value The URL subdomain of the endpoint. For example, if the URL for Endpoint is https://abcde.veo.endpoints.event.amazonaws.com, then the EndpointId is abcde.veo.
     */
    @JvmName("ppmrogvqhqpjsdph")
    public suspend fun endpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointId = mapped
    }

    /**
     * @param value List of AWS resources, identified by Amazon Resource Name (ARN), which the event primarily concerns. Any number, including zero, may be present.
     */
    @JvmName("hplximrywbwtvcyg")
    public suspend fun resources(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param values List of AWS resources, identified by Amazon Resource Name (ARN), which the event primarily concerns. Any number, including zero, may be present.
     */
    @JvmName("xitpmpdfflbjqhps")
    public suspend fun resources(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param value Source resource of the pipe (typically an ARN).
     */
    @JvmName("qcqvjjyyqgotjqsy")
    public suspend fun source(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value The time stamp of the event, per RFC3339. If no time stamp is provided, the time stamp of the PutEvents call is used. This is the JSON path to the field in the event e.g. $.detail.timestamp
     */
    @JvmName("xqvayvdfxkhoatpj")
    public suspend fun time(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.time = mapped
    }

    internal fun build(): PipeTargetParametersEventbridgeEventBusParametersArgs =
        PipeTargetParametersEventbridgeEventBusParametersArgs(
            detailType = detailType,
            endpointId = endpointId,
            resources = resources,
            source = source,
            time = time,
        )
}
