@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeTargetParametersHttpParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property headerParameters Key-value mapping of the headers that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.
 * @property pathParameterValues The path parameter values to be used to populate API Gateway REST API or EventBridge ApiDestination path wildcards ("*").
 * @property queryStringParameters Key-value mapping of the query strings that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.
 */
public data class PipeTargetParametersHttpParametersArgs(
    public val headerParameters: Output<Map<String, String>>? = null,
    public val pathParameterValues: Output<String>? = null,
    public val queryStringParameters: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeTargetParametersHttpParametersArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeTargetParametersHttpParametersArgs =
        com.pulumi.aws.pipes.inputs.PipeTargetParametersHttpParametersArgs.builder()
            .headerParameters(
                headerParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .pathParameterValues(pathParameterValues?.applyValue({ args0 -> args0 }))
            .queryStringParameters(
                queryStringParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PipeTargetParametersHttpParametersArgs].
 */
@PulumiTagMarker
public class PipeTargetParametersHttpParametersArgsBuilder internal constructor() {
    private var headerParameters: Output<Map<String, String>>? = null

    private var pathParameterValues: Output<String>? = null

    private var queryStringParameters: Output<Map<String, String>>? = null

    /**
     * @param value Key-value mapping of the headers that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.
     */
    @JvmName("aewmsovbgoreaboy")
    public suspend fun headerParameters(`value`: Output<Map<String, String>>) {
        this.headerParameters = value
    }

    /**
     * @param value The path parameter values to be used to populate API Gateway REST API or EventBridge ApiDestination path wildcards ("*").
     */
    @JvmName("lpvurytmbupffejs")
    public suspend fun pathParameterValues(`value`: Output<String>) {
        this.pathParameterValues = value
    }

    /**
     * @param value Key-value mapping of the query strings that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.
     */
    @JvmName("eehuifcipqxgsdgo")
    public suspend fun queryStringParameters(`value`: Output<Map<String, String>>) {
        this.queryStringParameters = value
    }

    /**
     * @param value Key-value mapping of the headers that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.
     */
    @JvmName("plaemspsrygnlidj")
    public suspend fun headerParameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headerParameters = mapped
    }

    /**
     * @param values Key-value mapping of the headers that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.
     */
    @JvmName("rlbjkcdfqluaoycy")
    public fun headerParameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headerParameters = mapped
    }

    /**
     * @param value The path parameter values to be used to populate API Gateway REST API or EventBridge ApiDestination path wildcards ("*").
     */
    @JvmName("acsebmwvfncbsgvp")
    public suspend fun pathParameterValues(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pathParameterValues = mapped
    }

    /**
     * @param value Key-value mapping of the query strings that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.
     */
    @JvmName("egdgalsawgegqgfu")
    public suspend fun queryStringParameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryStringParameters = mapped
    }

    /**
     * @param values Key-value mapping of the query strings that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.
     */
    @JvmName("rtokjlqlgrqfvvbd")
    public fun queryStringParameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryStringParameters = mapped
    }

    internal fun build(): PipeTargetParametersHttpParametersArgs =
        PipeTargetParametersHttpParametersArgs(
            headerParameters = headerParameters,
            pathParameterValues = pathParameterValues,
            queryStringParameters = queryStringParameters,
        )
}
