@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeTargetParametersRedshiftDataParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property database The name of the database. Required when authenticating using temporary credentials.
 * @property dbUser The database user name. Required when authenticating using temporary credentials.
 * @property secretManagerArn The name or ARN of the secret that enables access to the database. Required when authenticating using Secrets Manager.
 * @property sqls List of SQL statements text to run, each of maximum length of 100,000.
 * @property statementName The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
 * @property withEvent Indicates whether to send an event back to EventBridge after the SQL statement runs.
 */
public data class PipeTargetParametersRedshiftDataParametersArgs(
    public val database: Output<String>,
    public val dbUser: Output<String>? = null,
    public val secretManagerArn: Output<String>? = null,
    public val sqls: Output<List<String>>,
    public val statementName: Output<String>? = null,
    public val withEvent: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeTargetParametersRedshiftDataParametersArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeTargetParametersRedshiftDataParametersArgs =
        com.pulumi.aws.pipes.inputs.PipeTargetParametersRedshiftDataParametersArgs.builder()
            .database(database.applyValue({ args0 -> args0 }))
            .dbUser(dbUser?.applyValue({ args0 -> args0 }))
            .secretManagerArn(secretManagerArn?.applyValue({ args0 -> args0 }))
            .sqls(sqls.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .statementName(statementName?.applyValue({ args0 -> args0 }))
            .withEvent(withEvent?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeTargetParametersRedshiftDataParametersArgs].
 */
@PulumiTagMarker
public class PipeTargetParametersRedshiftDataParametersArgsBuilder internal constructor() {
    private var database: Output<String>? = null

    private var dbUser: Output<String>? = null

    private var secretManagerArn: Output<String>? = null

    private var sqls: Output<List<String>>? = null

    private var statementName: Output<String>? = null

    private var withEvent: Output<Boolean>? = null

    /**
     * @param value The name of the database. Required when authenticating using temporary credentials.
     */
    @JvmName("whnwxksbwidxydnb")
    public suspend fun database(`value`: Output<String>) {
        this.database = value
    }

    /**
     * @param value The database user name. Required when authenticating using temporary credentials.
     */
    @JvmName("xitqlrtedwwmnlop")
    public suspend fun dbUser(`value`: Output<String>) {
        this.dbUser = value
    }

    /**
     * @param value The name or ARN of the secret that enables access to the database. Required when authenticating using Secrets Manager.
     */
    @JvmName("ukfupchuqopauvdp")
    public suspend fun secretManagerArn(`value`: Output<String>) {
        this.secretManagerArn = value
    }

    /**
     * @param value List of SQL statements text to run, each of maximum length of 100,000.
     */
    @JvmName("roniwjugfaxmiiml")
    public suspend fun sqls(`value`: Output<List<String>>) {
        this.sqls = value
    }

    @JvmName("ydohkbpmxgngucpi")
    public suspend fun sqls(vararg values: Output<String>) {
        this.sqls = Output.all(values.asList())
    }

    /**
     * @param values List of SQL statements text to run, each of maximum length of 100,000.
     */
    @JvmName("udfekxplxhnxcsdy")
    public suspend fun sqls(values: List<Output<String>>) {
        this.sqls = Output.all(values)
    }

    /**
     * @param value The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
     */
    @JvmName("cdcrbdcxsuulrxfy")
    public suspend fun statementName(`value`: Output<String>) {
        this.statementName = value
    }

    /**
     * @param value Indicates whether to send an event back to EventBridge after the SQL statement runs.
     */
    @JvmName("ewcbkufggcegukdy")
    public suspend fun withEvent(`value`: Output<Boolean>) {
        this.withEvent = value
    }

    /**
     * @param value The name of the database. Required when authenticating using temporary credentials.
     */
    @JvmName("jkepfieetwowbard")
    public suspend fun database(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.database = mapped
    }

    /**
     * @param value The database user name. Required when authenticating using temporary credentials.
     */
    @JvmName("rlcatdtyiqnfvhdm")
    public suspend fun dbUser(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbUser = mapped
    }

    /**
     * @param value The name or ARN of the secret that enables access to the database. Required when authenticating using Secrets Manager.
     */
    @JvmName("mrbgnfujcbppknnl")
    public suspend fun secretManagerArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretManagerArn = mapped
    }

    /**
     * @param value List of SQL statements text to run, each of maximum length of 100,000.
     */
    @JvmName("hchpnysnblewjowk")
    public suspend fun sqls(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqls = mapped
    }

    /**
     * @param values List of SQL statements text to run, each of maximum length of 100,000.
     */
    @JvmName("acphtfcqycsknkiy")
    public suspend fun sqls(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqls = mapped
    }

    /**
     * @param value The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
     */
    @JvmName("dljdmlsylqpfqojo")
    public suspend fun statementName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statementName = mapped
    }

    /**
     * @param value Indicates whether to send an event back to EventBridge after the SQL statement runs.
     */
    @JvmName("jnkmxnibbqlddjet")
    public suspend fun withEvent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.withEvent = mapped
    }

    internal fun build(): PipeTargetParametersRedshiftDataParametersArgs =
        PipeTargetParametersRedshiftDataParametersArgs(
            database = database ?: throw PulumiNullFieldException("database"),
            dbUser = dbUser,
            secretManagerArn = secretManagerArn,
            sqls = sqls ?: throw PulumiNullFieldException("sqls"),
            statementName = statementName,
            withEvent = withEvent,
        )
}
