@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeTargetParametersSqsQueueParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property messageDeduplicationId This parameter applies only to FIFO (first-in-first-out) queues. The token used for deduplication of sent messages.
 * @property messageGroupId The FIFO message group ID to use as the target.
 */
public data class PipeTargetParametersSqsQueueParametersArgs(
    public val messageDeduplicationId: Output<String>? = null,
    public val messageGroupId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeTargetParametersSqsQueueParametersArgs> {
    override fun toJava(): com.pulumi.aws.pipes.inputs.PipeTargetParametersSqsQueueParametersArgs =
        com.pulumi.aws.pipes.inputs.PipeTargetParametersSqsQueueParametersArgs.builder()
            .messageDeduplicationId(messageDeduplicationId?.applyValue({ args0 -> args0 }))
            .messageGroupId(messageGroupId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeTargetParametersSqsQueueParametersArgs].
 */
@PulumiTagMarker
public class PipeTargetParametersSqsQueueParametersArgsBuilder internal constructor() {
    private var messageDeduplicationId: Output<String>? = null

    private var messageGroupId: Output<String>? = null

    /**
     * @param value This parameter applies only to FIFO (first-in-first-out) queues. The token used for deduplication of sent messages.
     */
    @JvmName("xjgiaweffxghjjip")
    public suspend fun messageDeduplicationId(`value`: Output<String>) {
        this.messageDeduplicationId = value
    }

    /**
     * @param value The FIFO message group ID to use as the target.
     */
    @JvmName("nuropdccwphxwqfv")
    public suspend fun messageGroupId(`value`: Output<String>) {
        this.messageGroupId = value
    }

    /**
     * @param value This parameter applies only to FIFO (first-in-first-out) queues. The token used for deduplication of sent messages.
     */
    @JvmName("maafrsueltbvgccb")
    public suspend fun messageDeduplicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageDeduplicationId = mapped
    }

    /**
     * @param value The FIFO message group ID to use as the target.
     */
    @JvmName("gahapbejaajuylnl")
    public suspend fun messageGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageGroupId = mapped
    }

    internal fun build(): PipeTargetParametersSqsQueueParametersArgs =
        PipeTargetParametersSqsQueueParametersArgs(
            messageDeduplicationId = messageDeduplicationId,
            messageGroupId = messageGroupId,
        )
}
