@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.inputs

import com.pulumi.aws.pipes.inputs.PipeTargetParametersStepFunctionStateMachineParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property invocationType Specify whether to invoke the function synchronously or asynchronously. Valid Values: REQUEST_RESPONSE, FIRE_AND_FORGET.
 */
public data class PipeTargetParametersStepFunctionStateMachineParametersArgs(
    public val invocationType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.pipes.inputs.PipeTargetParametersStepFunctionStateMachineParametersArgs> {
    override fun toJava():
        com.pulumi.aws.pipes.inputs.PipeTargetParametersStepFunctionStateMachineParametersArgs =
        com.pulumi.aws.pipes.inputs.PipeTargetParametersStepFunctionStateMachineParametersArgs.builder()
            .invocationType(invocationType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipeTargetParametersStepFunctionStateMachineParametersArgs].
 */
@PulumiTagMarker
public class PipeTargetParametersStepFunctionStateMachineParametersArgsBuilder internal
constructor() {
    private var invocationType: Output<String>? = null

    /**
     * @param value Specify whether to invoke the function synchronously or asynchronously. Valid Values: REQUEST_RESPONSE, FIRE_AND_FORGET.
     */
    @JvmName("vgjassijesevwnno")
    public suspend fun invocationType(`value`: Output<String>) {
        this.invocationType = value
    }

    /**
     * @param value Specify whether to invoke the function synchronously or asynchronously. Valid Values: REQUEST_RESPONSE, FIRE_AND_FORGET.
     */
    @JvmName("nyladvqklijeulke")
    public suspend fun invocationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.invocationType = mapped
    }

    internal fun build(): PipeTargetParametersStepFunctionStateMachineParametersArgs =
        PipeTargetParametersStepFunctionStateMachineParametersArgs(
            invocationType = invocationType ?: throw PulumiNullFieldException("invocationType"),
        )
}
