@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property httpParameters Contains the HTTP parameters to use when the target is a API Gateway REST endpoint or EventBridge ApiDestination. If you specify an API Gateway REST API or EventBridge ApiDestination as a target, you can use this parameter to specify headers, path parameters, and query string keys/values as part of your target invoking request. If you're using ApiDestinations, the corresponding Connection can also have these values configured. In case of any conflicting keys, values from the Connection take precedence. Detailed below.
 * @property inputTemplate Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the target. Maximum length of 8192 characters.
 */
public data class PipeEnrichmentParameters(
    public val httpParameters: PipeEnrichmentParametersHttpParameters? = null,
    public val inputTemplate: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.pipes.outputs.PipeEnrichmentParameters):
            PipeEnrichmentParameters = PipeEnrichmentParameters(
            httpParameters = javaType.httpParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeEnrichmentParametersHttpParameters.Companion.toKotlin(args0)
                })
            }).orElse(null),
            inputTemplate = javaType.inputTemplate().map({ args0 -> args0 }).orElse(null),
        )
    }
}
