@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property batchSize The maximum number of records to include in each batch. Maximum value of 10000.
 * @property credentials The credentials needed to access the resource. Detailed below.
 * @property maximumBatchingWindowInSeconds The maximum length of a time to wait for events. Maximum value of 300.
 * @property queueName The name of the destination queue to consume. Maximum length of 1000.
 */
public data class PipeSourceParametersActivemqBrokerParameters(
    public val batchSize: Int? = null,
    public val credentials: PipeSourceParametersActivemqBrokerParametersCredentials,
    public val maximumBatchingWindowInSeconds: Int? = null,
    public val queueName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.pipes.outputs.PipeSourceParametersActivemqBrokerParameters):
            PipeSourceParametersActivemqBrokerParameters = PipeSourceParametersActivemqBrokerParameters(
            batchSize = javaType.batchSize().map({ args0 -> args0 }).orElse(null),
            credentials = javaType.credentials().let({ args0 ->
                com.pulumi.aws.pipes.kotlin.outputs.PipeSourceParametersActivemqBrokerParametersCredentials.Companion.toKotlin(args0)
            }),
            maximumBatchingWindowInSeconds = javaType.maximumBatchingWindowInSeconds().map({ args0 ->
                args0
            }).orElse(null),
            queueName = javaType.queueName(),
        )
    }
}
