@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property batchSize The maximum number of records to include in each batch. Maximum value of 10000.
 * @property consumerGroupId The name of the destination queue to consume. Maximum value of 200.
 * @property credentials The credentials needed to access the resource. Detailed below.
 * @property maximumBatchingWindowInSeconds The maximum length of a time to wait for events. Maximum value of 300.
 * @property startingPosition The position in a stream from which to start reading. Valid values: TRIM_HORIZON, LATEST.
 * @property topicName The name of the topic that the pipe will read from. Maximum length of 249.
 */
public data class PipeSourceParametersManagedStreamingKafkaParameters(
    public val batchSize: Int? = null,
    public val consumerGroupId: String? = null,
    public val credentials: PipeSourceParametersManagedStreamingKafkaParametersCredentials? = null,
    public val maximumBatchingWindowInSeconds: Int? = null,
    public val startingPosition: String? = null,
    public val topicName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.pipes.outputs.PipeSourceParametersManagedStreamingKafkaParameters):
            PipeSourceParametersManagedStreamingKafkaParameters =
            PipeSourceParametersManagedStreamingKafkaParameters(
                batchSize = javaType.batchSize().map({ args0 -> args0 }).orElse(null),
                consumerGroupId = javaType.consumerGroupId().map({ args0 -> args0 }).orElse(null),
                credentials = javaType.credentials().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.pipes.kotlin.outputs.PipeSourceParametersManagedStreamingKafkaParametersCredentials.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                maximumBatchingWindowInSeconds = javaType.maximumBatchingWindowInSeconds().map({ args0 ->
                    args0
                }).orElse(null),
                startingPosition = javaType.startingPosition().map({ args0 -> args0 }).orElse(null),
                topicName = javaType.topicName(),
            )
    }
}
