@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property batchSize The maximum number of records to include in each batch. Maximum value of 10000.
 * @property credentials The credentials needed to access the resource. Detailed below.
 * @property maximumBatchingWindowInSeconds The maximum length of a time to wait for events. Maximum value of 300.
 * @property queueName The name of the destination queue to consume. Maximum length of 1000.
 * @property virtualHost The name of the virtual host associated with the source broker. Maximum length of 200.
 */
public data class PipeSourceParametersRabbitmqBrokerParameters(
    public val batchSize: Int? = null,
    public val credentials: PipeSourceParametersRabbitmqBrokerParametersCredentials,
    public val maximumBatchingWindowInSeconds: Int? = null,
    public val queueName: String,
    public val virtualHost: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.pipes.outputs.PipeSourceParametersRabbitmqBrokerParameters):
            PipeSourceParametersRabbitmqBrokerParameters = PipeSourceParametersRabbitmqBrokerParameters(
            batchSize = javaType.batchSize().map({ args0 -> args0 }).orElse(null),
            credentials = javaType.credentials().let({ args0 ->
                com.pulumi.aws.pipes.kotlin.outputs.PipeSourceParametersRabbitmqBrokerParametersCredentials.Companion.toKotlin(args0)
            }),
            maximumBatchingWindowInSeconds = javaType.maximumBatchingWindowInSeconds().map({ args0 ->
                args0
            }).orElse(null),
            queueName = javaType.queueName(),
            virtualHost = javaType.virtualHost().map({ args0 -> args0 }).orElse(null),
        )
    }
}
