@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property additionalBootstrapServers An array of server URLs. Maximum number of 2 items, each of maximum length 300.
 * @property batchSize The maximum number of records to include in each batch. Maximum value of 10000.
 * @property consumerGroupId The name of the destination queue to consume. Maximum value of 200.
 * @property credentials The credentials needed to access the resource. Detailed below.
 * @property maximumBatchingWindowInSeconds The maximum length of a time to wait for events. Maximum value of 300.
 * @property serverRootCaCertificate The ARN of the Secrets Manager secret used for certification.
 * @property startingPosition The position in a stream from which to start reading. Valid values: TRIM_HORIZON, LATEST.
 * @property topicName The name of the topic that the pipe will read from. Maximum length of 249.
 * @property vpc This structure specifies the VPC subnets and security groups for the stream, and whether a public IP address is to be used. Detailed below.
 */
public data class PipeSourceParametersSelfManagedKafkaParameters(
    public val additionalBootstrapServers: List<String>? = null,
    public val batchSize: Int? = null,
    public val consumerGroupId: String? = null,
    public val credentials: PipeSourceParametersSelfManagedKafkaParametersCredentials? = null,
    public val maximumBatchingWindowInSeconds: Int? = null,
    public val serverRootCaCertificate: String? = null,
    public val startingPosition: String? = null,
    public val topicName: String,
    public val vpc: PipeSourceParametersSelfManagedKafkaParametersVpc? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.pipes.outputs.PipeSourceParametersSelfManagedKafkaParameters):
            PipeSourceParametersSelfManagedKafkaParameters =
            PipeSourceParametersSelfManagedKafkaParameters(
                additionalBootstrapServers = javaType.additionalBootstrapServers().map({ args0 -> args0 }),
                batchSize = javaType.batchSize().map({ args0 -> args0 }).orElse(null),
                consumerGroupId = javaType.consumerGroupId().map({ args0 -> args0 }).orElse(null),
                credentials = javaType.credentials().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.pipes.kotlin.outputs.PipeSourceParametersSelfManagedKafkaParametersCredentials.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                maximumBatchingWindowInSeconds = javaType.maximumBatchingWindowInSeconds().map({ args0 ->
                    args0
                }).orElse(null),
                serverRootCaCertificate = javaType.serverRootCaCertificate().map({ args0 -> args0 }).orElse(null),
                startingPosition = javaType.startingPosition().map({ args0 -> args0 }).orElse(null),
                topicName = javaType.topicName(),
                vpc = javaType.vpc().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.pipes.kotlin.outputs.PipeSourceParametersSelfManagedKafkaParametersVpc.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
