@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property securityGroups List of security groups associated with the stream. These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.
 * @property subnets List of the subnets associated with the stream. These subnets must all be in the same VPC. You can specify as many as 16 subnets.
 */
public data class PipeSourceParametersSelfManagedKafkaParametersVpc(
    public val securityGroups: List<String>? = null,
    public val subnets: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.pipes.outputs.PipeSourceParametersSelfManagedKafkaParametersVpc):
            PipeSourceParametersSelfManagedKafkaParametersVpc =
            PipeSourceParametersSelfManagedKafkaParametersVpc(
                securityGroups = javaType.securityGroups().map({ args0 -> args0 }),
                subnets = javaType.subnets().map({ args0 -> args0 }),
            )
    }
}
