@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property arrayProperties The array properties for the submitted job, such as the size of the array. The array size can be between 2 and 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only if the target is an AWS Batch job. Detailed below.
 * @property containerOverrides The overrides that are sent to a container. Detailed below.
 * @property dependsOns A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a SEQUENTIAL type dependency without specifying a job ID for array jobs so that each child array job completes sequentially, starting at index 0. You can also specify an N_TO_N type dependency with a job ID for array jobs. In that case, each index child of this job must wait for the corresponding index child of each dependency to complete before it can begin. Detailed below.
 * @property jobDefinition The job definition used by this job. This value can be one of name, name:revision, or the Amazon Resource Name (ARN) for the job definition. If name is specified without a revision then the latest active revision is used.
 * @property jobName The name of the job. It can be up to 128 letters long.
 * @property parameters Additional parameters passed to the job that replace parameter substitution placeholders that are set in the job definition. Parameters are specified as a key and value pair mapping. Parameters included here override any corresponding parameter defaults from the job definition. Detailed below.
 * @property retryStrategy The retry strategy to use for failed jobs. When a retry strategy is specified here, it overrides the retry strategy defined in the job definition. Detailed below.
 */
public data class PipeTargetParametersBatchJobParameters(
    public val arrayProperties: PipeTargetParametersBatchJobParametersArrayProperties? = null,
    public val containerOverrides: PipeTargetParametersBatchJobParametersContainerOverrides? = null,
    public val dependsOns: List<PipeTargetParametersBatchJobParametersDependsOn>? = null,
    public val jobDefinition: String,
    public val jobName: String,
    public val parameters: Map<String, String>? = null,
    public val retryStrategy: PipeTargetParametersBatchJobParametersRetryStrategy? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.pipes.outputs.PipeTargetParametersBatchJobParameters):
            PipeTargetParametersBatchJobParameters = PipeTargetParametersBatchJobParameters(
            arrayProperties = javaType.arrayProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeTargetParametersBatchJobParametersArrayProperties.Companion.toKotlin(args0)
                })
            }).orElse(null),
            containerOverrides = javaType.containerOverrides().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeTargetParametersBatchJobParametersContainerOverrides.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dependsOns = javaType.dependsOns().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeTargetParametersBatchJobParametersDependsOn.Companion.toKotlin(args0)
                })
            }),
            jobDefinition = javaType.jobDefinition(),
            jobName = javaType.jobName(),
            parameters = javaType.parameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            retryStrategy = javaType.retryStrategy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pipes.kotlin.outputs.PipeTargetParametersBatchJobParametersRetryStrategy.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
