@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property base The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. If no value is specified, the default value of 0 is used. Maximum value of 100,000.
 * @property capacityProvider The short name of the capacity provider. Maximum value of 255.
 * @property weight The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied. Maximum value of 1,000.
 */
public data class PipeTargetParametersEcsTaskParametersCapacityProviderStrategy(
    public val base: Int? = null,
    public val capacityProvider: String,
    public val weight: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.pipes.outputs.PipeTargetParametersEcsTaskParametersCapacityProviderStrategy):
            PipeTargetParametersEcsTaskParametersCapacityProviderStrategy =
            PipeTargetParametersEcsTaskParametersCapacityProviderStrategy(
                base = javaType.base().map({ args0 -> args0 }).orElse(null),
                capacityProvider = javaType.capacityProvider(),
                weight = javaType.weight().map({ args0 -> args0 }).orElse(null),
            )
    }
}
