@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property commands List of commands to send to the container that overrides the default command from the Docker image or the task definition. You must also specify a container name.
 * @property cpu The number of cpu units reserved for the container, instead of the default value from the task definition. You must also specify a container name.
 * @property environmentFiles A list of files containing the environment variables to pass to a container, instead of the value from the container definition. Detailed below.
 * @property environments The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name. Detailed below.
 * @property memory The hard limit (in MiB) of memory to present to the container, instead of the default value from the task definition. If your container attempts to exceed the memory specified here, the container is killed. You must also specify a container name.
 * @property memoryReservation The soft limit (in MiB) of memory to reserve for the container, instead of the default value from the task definition. You must also specify a container name.
 * @property name Name of the pipe. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
 * @property resourceRequirements The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. Detailed below.
 */
public data class PipeTargetParametersEcsTaskParametersOverridesContainerOverride(
    public val commands: List<String>? = null,
    public val cpu: Int? = null,
    public val environmentFiles:
    List<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFile>? = null,
    public val environments:
    List<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironment>? = null,
    public val memory: Int? = null,
    public val memoryReservation: Int? = null,
    public val name: String? = null,
    public val resourceRequirements:
    List<PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirement>? =
        null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.pipes.outputs.PipeTargetParametersEcsTaskParametersOverridesContainerOverride):
            PipeTargetParametersEcsTaskParametersOverridesContainerOverride =
            PipeTargetParametersEcsTaskParametersOverridesContainerOverride(
                commands = javaType.commands().map({ args0 -> args0 }),
                cpu = javaType.cpu().map({ args0 -> args0 }).orElse(null),
                environmentFiles = javaType.environmentFiles().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.pipes.kotlin.outputs.PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFile.Companion.toKotlin(args0)
                    })
                }),
                environments = javaType.environments().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.pipes.kotlin.outputs.PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironment.Companion.toKotlin(args0)
                    })
                }),
                memory = javaType.memory().map({ args0 -> args0 }).orElse(null),
                memoryReservation = javaType.memoryReservation().map({ args0 -> args0 }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                resourceRequirements = javaType.resourceRequirements().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.pipes.kotlin.outputs.PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirement.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
