@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deviceName The Elastic Inference accelerator device name to override for the task. This parameter must match a deviceName specified in the task definition.
 * @property deviceType The Elastic Inference accelerator type to use.
 */
public data class PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverride(
    public val deviceName: String? = null,
    public val deviceType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.pipes.outputs.PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverride):
            PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverride =
            PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverride(
                deviceName = javaType.deviceName().map({ args0 -> args0 }).orElse(null),
                deviceType = javaType.deviceType().map({ args0 -> args0 }).orElse(null),
            )
    }
}
