@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property detailType A free-form string, with a maximum of 128 characters, used to decide what fields to expect in the event detail.
 * @property endpointId The URL subdomain of the endpoint. For example, if the URL for Endpoint is https://abcde.veo.endpoints.event.amazonaws.com, then the EndpointId is abcde.veo.
 * @property resources List of AWS resources, identified by Amazon Resource Name (ARN), which the event primarily concerns. Any number, including zero, may be present.
 * @property source Source resource of the pipe (typically an ARN).
 * @property time The time stamp of the event, per RFC3339. If no time stamp is provided, the time stamp of the PutEvents call is used. This is the JSON path to the field in the event e.g. $.detail.timestamp
 */
public data class PipeTargetParametersEventbridgeEventBusParameters(
    public val detailType: String? = null,
    public val endpointId: String? = null,
    public val resources: List<String>? = null,
    public val source: String? = null,
    public val time: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.pipes.outputs.PipeTargetParametersEventbridgeEventBusParameters):
            PipeTargetParametersEventbridgeEventBusParameters =
            PipeTargetParametersEventbridgeEventBusParameters(
                detailType = javaType.detailType().map({ args0 -> args0 }).orElse(null),
                endpointId = javaType.endpointId().map({ args0 -> args0 }).orElse(null),
                resources = javaType.resources().map({ args0 -> args0 }),
                source = javaType.source().map({ args0 -> args0 }).orElse(null),
                time = javaType.time().map({ args0 -> args0 }).orElse(null),
            )
    }
}
