@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pipes.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property messageDeduplicationId This parameter applies only to FIFO (first-in-first-out) queues. The token used for deduplication of sent messages.
 * @property messageGroupId The FIFO message group ID to use as the target.
 */
public data class PipeTargetParametersSqsQueueParameters(
    public val messageDeduplicationId: String? = null,
    public val messageGroupId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.pipes.outputs.PipeTargetParametersSqsQueueParameters):
            PipeTargetParametersSqsQueueParameters = PipeTargetParametersSqsQueueParameters(
            messageDeduplicationId = javaType.messageDeduplicationId().map({ args0 -> args0 }).orElse(null),
            messageGroupId = javaType.messageGroupId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
