@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pricing.kotlin

import com.pulumi.aws.pricing.PricingFunctions.getProductPlain
import com.pulumi.aws.pricing.kotlin.inputs.GetProductFilter
import com.pulumi.aws.pricing.kotlin.inputs.GetProductPlainArgs
import com.pulumi.aws.pricing.kotlin.inputs.GetProductPlainArgsBuilder
import com.pulumi.aws.pricing.kotlin.outputs.GetProductResult
import com.pulumi.aws.pricing.kotlin.outputs.GetProductResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

public object PricingFunctions {
    /**
     * Use this data source to get the pricing information of all products in AWS.
     * This data source is only available in a us-east-1 or ap-south-1 provider.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.pricing.PricingFunctions;
     * import com.pulumi.aws.pricing.inputs.GetProductArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = PricingFunctions.getProduct(GetProductArgs.builder()
     *             .filters(
     *                 GetProductFilterArgs.builder()
     *                     .field("instanceType")
     *                     .value("c5.xlarge")
     *                     .build(),
     *                 GetProductFilterArgs.builder()
     *                     .field("operatingSystem")
     *                     .value("Linux")
     *                     .build(),
     *                 GetProductFilterArgs.builder()
     *                     .field("location")
     *                     .value("US East (N. Virginia)")
     *                     .build(),
     *                 GetProductFilterArgs.builder()
     *                     .field("preInstalledSw")
     *                     .value("NA")
     *                     .build(),
     *                 GetProductFilterArgs.builder()
     *                     .field("licenseModel")
     *                     .value("No License required")
     *                     .build(),
     *                 GetProductFilterArgs.builder()
     *                     .field("tenancy")
     *                     .value("Shared")
     *                     .build(),
     *                 GetProductFilterArgs.builder()
     *                     .field("capacitystatus")
     *                     .value("Used")
     *                     .build())
     *             .serviceCode("AmazonEC2")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getProduct.
     * @return A collection of values returned by getProduct.
     */
    public suspend fun getProduct(argument: GetProductPlainArgs): GetProductResult =
        toKotlin(getProductPlain(argument.toJava()).await())

    /**
     * @see [getProduct].
     * @param filters List of filters. Passed directly to the API (see GetProducts API reference). These filters must describe a single product, this resource will fail if more than one product is returned by the API.
     * @param serviceCode Code of the service. Available service codes can be fetched using the DescribeServices pricing API call.
     * @return A collection of values returned by getProduct.
     */
    public suspend fun getProduct(filters: List<GetProductFilter>, serviceCode: String):
        GetProductResult {
        val argument = GetProductPlainArgs(
            filters = filters,
            serviceCode = serviceCode,
        )
        return toKotlin(getProductPlain(argument.toJava()).await())
    }

    /**
     * @see [getProduct].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;pricing&#46;kotlin&#46;inputs&#46;GetProductPlainArgs].
     * @return A collection of values returned by getProduct.
     */
    public suspend fun getProduct(argument: suspend GetProductPlainArgsBuilder.() -> Unit):
        GetProductResult {
        val builder = GetProductPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getProductPlain(builtArgument.toJava()).await())
    }
}
