@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pricing.kotlin.inputs

import com.pulumi.aws.pricing.inputs.GetProductFilter.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property field Product attribute name that you want to filter on.
 * @property value Product attribute value that you want to filter on.
 */
public data class GetProductFilter(
    public val `field`: String,
    public val `value`: String,
) : ConvertibleToJava<com.pulumi.aws.pricing.inputs.GetProductFilter> {
    override fun toJava(): com.pulumi.aws.pricing.inputs.GetProductFilter =
        com.pulumi.aws.pricing.inputs.GetProductFilter.builder()
            .`field`(`field`.let({ args0 -> args0 }))
            .`value`(`value`.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProductFilter].
 */
@PulumiTagMarker
public class GetProductFilterBuilder internal constructor() {
    private var `field`: String? = null

    private var `value`: String? = null

    /**
     * @param value Product attribute name that you want to filter on.
     */
    @JvmName("wkffioxcgorsmcgh")
    public suspend fun `field`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.`field` = mapped
    }

    /**
     * @param value Product attribute value that you want to filter on.
     */
    @JvmName("cuewmcrdkocgebhn")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.`value` = mapped
    }

    internal fun build(): GetProductFilter = GetProductFilter(
        `field` = `field` ?: throw PulumiNullFieldException("field"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
