@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pricing.kotlin.inputs

import com.pulumi.aws.pricing.inputs.GetProductPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getProduct.
 * @property filters List of filters. Passed directly to the API (see GetProducts API reference). These filters must describe a single product, this resource will fail if more than one product is returned by the API.
 * @property serviceCode Code of the service. Available service codes can be fetched using the DescribeServices pricing API call.
 */
public data class GetProductPlainArgs(
    public val filters: List<GetProductFilter>,
    public val serviceCode: String,
) : ConvertibleToJava<com.pulumi.aws.pricing.inputs.GetProductPlainArgs> {
    override fun toJava(): com.pulumi.aws.pricing.inputs.GetProductPlainArgs =
        com.pulumi.aws.pricing.inputs.GetProductPlainArgs.builder()
            .filters(filters.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .serviceCode(serviceCode.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProductPlainArgs].
 */
@PulumiTagMarker
public class GetProductPlainArgsBuilder internal constructor() {
    private var filters: List<GetProductFilter>? = null

    private var serviceCode: String? = null

    /**
     * @param value List of filters. Passed directly to the API (see GetProducts API reference). These filters must describe a single product, this resource will fail if more than one product is returned by the API.
     */
    @JvmName("ebrbqedrrlktxrqo")
    public suspend fun filters(`value`: List<GetProductFilter>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument List of filters. Passed directly to the API (see GetProducts API reference). These filters must describe a single product, this resource will fail if more than one product is returned by the API.
     */
    @JvmName("aipokjqoleetbhnr")
    public suspend fun filters(argument: List<suspend GetProductFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetProductFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument List of filters. Passed directly to the API (see GetProducts API reference). These filters must describe a single product, this resource will fail if more than one product is returned by the API.
     */
    @JvmName("oepxfoudvokvynwu")
    public suspend fun filters(vararg argument: suspend GetProductFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetProductFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument List of filters. Passed directly to the API (see GetProducts API reference). These filters must describe a single product, this resource will fail if more than one product is returned by the API.
     */
    @JvmName("cqjdjrevdwbagcra")
    public suspend fun filters(argument: suspend GetProductFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetProductFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values List of filters. Passed directly to the API (see GetProducts API reference). These filters must describe a single product, this resource will fail if more than one product is returned by the API.
     */
    @JvmName("sahvqumidrqiesto")
    public suspend fun filters(vararg values: GetProductFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Code of the service. Available service codes can be fetched using the DescribeServices pricing API call.
     */
    @JvmName("tgaaaqiybgottuxg")
    public suspend fun serviceCode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceCode = mapped
    }

    internal fun build(): GetProductPlainArgs = GetProductPlainArgs(
        filters = filters ?: throw PulumiNullFieldException("filters"),
        serviceCode = serviceCode ?: throw PulumiNullFieldException("serviceCode"),
    )
}
