@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.qldb.kotlin

import com.pulumi.aws.qldb.LedgerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS Quantum Ledger Database (QLDB) resource
 * > **NOTE:** Deletion protection is enabled by default. To successfully delete this resource via this provider, `deletion_protection = false` must be applied before attempting deletion.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.qldb.Ledger;
 * import com.pulumi.aws.qldb.LedgerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sample_ledger = new Ledger("sample-ledger", LedgerArgs.builder()
 *             .permissionsMode("STANDARD")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import QLDB Ledgers using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:qldb/ledger:Ledger sample-ledger sample-ledger
 * ```
 * @property deletionProtection The deletion protection for the QLDB Ledger instance. By default it is `true`. To delete this resource via the provider, this value must be configured to `false` and applied first before attempting deletion.
 * @property kmsKey The key in AWS Key Management Service (AWS KMS) to use for encryption of data at rest in the ledger. For more information, see the [AWS documentation](https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html). Valid values are `"AWS_OWNED_KMS_KEY"` to use an AWS KMS key that is owned and managed by AWS on your behalf, or the ARN of a valid symmetric customer managed KMS key.
 * @property name The friendly name for the QLDB Ledger instance. By default generated by the provider.
 * @property permissionsMode The permissions mode for the QLDB ledger instance. Specify either `ALLOW_ALL` or `STANDARD`.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class LedgerArgs(
    public val deletionProtection: Output<Boolean>? = null,
    public val kmsKey: Output<String>? = null,
    public val name: Output<String>? = null,
    public val permissionsMode: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.qldb.LedgerArgs> {
    override fun toJava(): com.pulumi.aws.qldb.LedgerArgs = com.pulumi.aws.qldb.LedgerArgs.builder()
        .deletionProtection(deletionProtection?.applyValue({ args0 -> args0 }))
        .kmsKey(kmsKey?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .permissionsMode(permissionsMode?.applyValue({ args0 -> args0 }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [LedgerArgs].
 */
@PulumiTagMarker
public class LedgerArgsBuilder internal constructor() {
    private var deletionProtection: Output<Boolean>? = null

    private var kmsKey: Output<String>? = null

    private var name: Output<String>? = null

    private var permissionsMode: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The deletion protection for the QLDB Ledger instance. By default it is `true`. To delete this resource via the provider, this value must be configured to `false` and applied first before attempting deletion.
     */
    @JvmName("qpiohvgqgpojpfut")
    public suspend fun deletionProtection(`value`: Output<Boolean>) {
        this.deletionProtection = value
    }

    /**
     * @param value The key in AWS Key Management Service (AWS KMS) to use for encryption of data at rest in the ledger. For more information, see the [AWS documentation](https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html). Valid values are `"AWS_OWNED_KMS_KEY"` to use an AWS KMS key that is owned and managed by AWS on your behalf, or the ARN of a valid symmetric customer managed KMS key.
     */
    @JvmName("gyaaonlorfrtosll")
    public suspend fun kmsKey(`value`: Output<String>) {
        this.kmsKey = value
    }

    /**
     * @param value The friendly name for the QLDB Ledger instance. By default generated by the provider.
     */
    @JvmName("vfvedoiadmgccaqj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The permissions mode for the QLDB ledger instance. Specify either `ALLOW_ALL` or `STANDARD`.
     */
    @JvmName("vosdtcsknwmmdiyq")
    public suspend fun permissionsMode(`value`: Output<String>) {
        this.permissionsMode = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pdwruiljcsemdpbl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The deletion protection for the QLDB Ledger instance. By default it is `true`. To delete this resource via the provider, this value must be configured to `false` and applied first before attempting deletion.
     */
    @JvmName("eokujoasyedrwkkp")
    public suspend fun deletionProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionProtection = mapped
    }

    /**
     * @param value The key in AWS Key Management Service (AWS KMS) to use for encryption of data at rest in the ledger. For more information, see the [AWS documentation](https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html). Valid values are `"AWS_OWNED_KMS_KEY"` to use an AWS KMS key that is owned and managed by AWS on your behalf, or the ARN of a valid symmetric customer managed KMS key.
     */
    @JvmName("dqntjvummmsryrbn")
    public suspend fun kmsKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKey = mapped
    }

    /**
     * @param value The friendly name for the QLDB Ledger instance. By default generated by the provider.
     */
    @JvmName("hjirbrjiynvtwofp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The permissions mode for the QLDB ledger instance. Specify either `ALLOW_ALL` or `STANDARD`.
     */
    @JvmName("cljabvdbileyvhny")
    public suspend fun permissionsMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissionsMode = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("smwkegyjpufifuyq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eosglmujjsdkoruj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): LedgerArgs = LedgerArgs(
        deletionProtection = deletionProtection,
        kmsKey = kmsKey,
        name = name,
        permissionsMode = permissionsMode,
        tags = tags,
    )
}
