@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.qldb.kotlin

import com.pulumi.aws.qldb.QldbFunctions.getLedgerPlain
import com.pulumi.aws.qldb.kotlin.inputs.GetLedgerPlainArgs
import com.pulumi.aws.qldb.kotlin.inputs.GetLedgerPlainArgsBuilder
import com.pulumi.aws.qldb.kotlin.outputs.GetLedgerResult
import com.pulumi.aws.qldb.kotlin.outputs.GetLedgerResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

public object QldbFunctions {
    /**
     * Use this data source to fetch information about a Quantum Ledger Database.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.qldb.QldbFunctions;
     * import com.pulumi.aws.qldb.inputs.GetLedgerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = QldbFunctions.getLedger(GetLedgerArgs.builder()
     *             .name("an_example_ledger")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getLedger.
     * @return A collection of values returned by getLedger.
     */
    public suspend fun getLedger(argument: GetLedgerPlainArgs): GetLedgerResult =
        toKotlin(getLedgerPlain(argument.toJava()).await())

    /**
     * @see [getLedger].
     * @param name Friendly name of the ledger to match.
     * @param tags
     * @return A collection of values returned by getLedger.
     */
    public suspend fun getLedger(name: String, tags: Map<String, String>? = null): GetLedgerResult {
        val argument = GetLedgerPlainArgs(
            name = name,
            tags = tags,
        )
        return toKotlin(getLedgerPlain(argument.toJava()).await())
    }

    /**
     * @see [getLedger].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;qldb&#46;kotlin&#46;inputs&#46;GetLedgerPlainArgs].
     * @return A collection of values returned by getLedger.
     */
    public suspend fun getLedger(argument: suspend GetLedgerPlainArgsBuilder.() -> Unit):
        GetLedgerResult {
        val builder = GetLedgerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getLedgerPlain(builtArgument.toJava()).await())
    }
}
