@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.qldb.kotlin

import com.pulumi.aws.qldb.kotlin.outputs.StreamKinesisConfiguration
import com.pulumi.aws.qldb.kotlin.outputs.StreamKinesisConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Stream].
 */
@PulumiTagMarker
public class StreamResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StreamArgs = StreamArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StreamArgsBuilder.() -> Unit) {
        val builder = StreamArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Stream {
        val builtJavaResource = com.pulumi.aws.qldb.Stream(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Stream(builtJavaResource)
    }
}

/**
 * Provides an AWS Quantum Ledger Database (QLDB) Stream resource
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.qldb.Stream;
 * import com.pulumi.aws.qldb.StreamArgs;
 * import com.pulumi.aws.qldb.inputs.StreamKinesisConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Stream("example", StreamArgs.builder()
 *             .inclusiveStartTime("2021-01-01T00:00:00Z")
 *             .kinesisConfiguration(StreamKinesisConfigurationArgs.builder()
 *                 .aggregationEnabled(false)
 *                 .streamArn("arn:aws:kinesis:us-east-1:xxxxxxxxxxxx:stream/example-kinesis-stream")
 *                 .build())
 *             .ledgerName("existing-ledger-name")
 *             .roleArn("sample-role-arn")
 *             .streamName("sample-ledger-stream")
 *             .tags(Map.of("example", "tag"))
 *             .build());
 *     }
 * }
 * ```
 */
public class Stream internal constructor(
    override val javaResource: com.pulumi.aws.qldb.Stream,
) : KotlinCustomResource(javaResource, StreamMapper) {
    /**
     * The ARN of the QLDB Stream.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The exclusive date and time that specifies when the stream ends. If you don't define this parameter, the stream runs indefinitely until you cancel it. It must be in ISO 8601 date and time format and in Universal Coordinated Time (UTC). For example: `"2019-06-13T21:36:34Z"`.
     */
    public val exclusiveEndTime: Output<String>?
        get() = javaResource.exclusiveEndTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The inclusive start date and time from which to start streaming journal data. This parameter must be in ISO 8601 date and time format and in Universal Coordinated Time (UTC). For example: `"2019-06-13T21:36:34Z"`.  This cannot be in the future and must be before `exclusive_end_time`.  If you provide a value that is before the ledger's `CreationDateTime`, QLDB effectively defaults it to the ledger's `CreationDateTime`.
     */
    public val inclusiveStartTime: Output<String>
        get() = javaResource.inclusiveStartTime().applyValue({ args0 -> args0 })

    /**
     * The configuration settings of the Kinesis Data Streams destination for your stream request. Documented below.
     */
    public val kinesisConfiguration: Output<StreamKinesisConfiguration>
        get() = javaResource.kinesisConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * The name of the QLDB ledger.
     */
    public val ledgerName: Output<String>
        get() = javaResource.ledgerName().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal stream to write data records to a Kinesis Data Streams resource.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * The name that you want to assign to the QLDB journal stream. User-defined names can help identify and indicate the purpose of a stream.  Your stream name must be unique among other active streams for a given ledger. Stream names have the same naming constraints as ledger names, as defined in the [Amazon QLDB Developer Guide](https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming).
     */
    public val streamName: Output<String>
        get() = javaResource.streamName().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object StreamMapper : ResourceMapper<Stream> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.qldb.Stream::class == javaResource::class

    override fun map(javaResource: Resource): Stream = Stream(
        javaResource as
            com.pulumi.aws.qldb.Stream,
    )
}

/**
 * @see [Stream].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Stream].
 */
public suspend fun stream(name: String, block: suspend StreamResourceBuilder.() -> Unit): Stream {
    val builder = StreamResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Stream].
 * @param name The _unique_ name of the resulting resource.
 */
public fun stream(name: String): Stream {
    val builder = StreamResourceBuilder()
    builder.name(name)
    return builder.build()
}
