@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.qldb.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property aggregationEnabled Enables QLDB to publish multiple data records in a single Kinesis Data Streams record, increasing the number of records sent per API call. Default: `true`.
 * @property streamArn The Amazon Resource Name (ARN) of the Kinesis Data Streams resource.
 */
public data class StreamKinesisConfiguration(
    public val aggregationEnabled: Boolean? = null,
    public val streamArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.qldb.outputs.StreamKinesisConfiguration):
            StreamKinesisConfiguration = StreamKinesisConfiguration(
            aggregationEnabled = javaType.aggregationEnabled().map({ args0 -> args0 }).orElse(null),
            streamArn = javaType.streamArn(),
        )
    }
}
