@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [AccountSubscription].
 */
@PulumiTagMarker
public class AccountSubscriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccountSubscriptionArgs = AccountSubscriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccountSubscriptionArgsBuilder.() -> Unit) {
        val builder = AccountSubscriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AccountSubscription {
        val builtJavaResource = com.pulumi.aws.quicksight.AccountSubscription(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AccountSubscription(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS QuickSight Account Subscription.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.AccountSubscription;
 * import com.pulumi.aws.quicksight.AccountSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var subscription = new AccountSubscription("subscription", AccountSubscriptionArgs.builder()
 *             .accountName("quicksight-pulumi")
 *             .authenticationMethod("IAM_AND_QUICKSIGHT")
 *             .edition("ENTERPRISE")
 *             .notificationEmail("notification@email.com")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * You cannot import this resource.
 */
public class AccountSubscription internal constructor(
    override val javaResource: com.pulumi.aws.quicksight.AccountSubscription,
) : KotlinCustomResource(javaResource, AccountSubscriptionMapper) {
    /**
     * Name of your Amazon QuickSight account. This name is unique over all of AWS, and it appears only when users sign in.
     */
    public val accountName: Output<String>
        get() = javaResource.accountName().applyValue({ args0 -> args0 })

    /**
     * Status of the Amazon QuickSight account's subscription.
     */
    public val accountSubscriptionStatus: Output<String>
        get() = javaResource.accountSubscriptionStatus().applyValue({ args0 -> args0 })

    /**
     * Name of your Active Directory. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account.
     */
    public val activeDirectoryName: Output<String>?
        get() = javaResource.activeDirectoryName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Admin group associated with your Active Directory. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account.
     */
    public val adminGroups: Output<List<String>>?
        get() = javaResource.adminGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Method that you want to use to authenticate your Amazon QuickSight account. Currently, the valid values for this parameter are `IAM_AND_QUICKSIGHT`, `IAM_ONLY`, and `ACTIVE_DIRECTORY`.
     */
    public val authenticationMethod: Output<String>
        get() = javaResource.authenticationMethod().applyValue({ args0 -> args0 })

    /**
     * Author group associated with your Active Directory.
     */
    public val authorGroups: Output<List<String>>?
        get() = javaResource.authorGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * AWS account ID hosting the QuickSight account. Default to provider account.
     */
    public val awsAccountId: Output<String>
        get() = javaResource.awsAccountId().applyValue({ args0 -> args0 })

    /**
     * A 10-digit phone number for the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
     */
    public val contactNumber: Output<String>?
        get() = javaResource.contactNumber().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Active Directory ID that is associated with your Amazon QuickSight account.
     */
    public val directoryId: Output<String>?
        get() = javaResource.directoryId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Edition of Amazon QuickSight that you want your account to have. Currently, you can choose from `STANDARD`, `ENTERPRISE` or `ENTERPRISE_AND_Q`.
     */
    public val edition: Output<String>
        get() = javaResource.edition().applyValue({ args0 -> args0 })

    /**
     * Email address of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
     */
    public val emailAddress: Output<String>?
        get() = javaResource.emailAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * First name of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
     */
    public val firstName: Output<String>?
        get() = javaResource.firstName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Last name of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
     */
    public val lastName: Output<String>?
        get() = javaResource.lastName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Email address that you want Amazon QuickSight to send notifications to regarding your Amazon QuickSight account or Amazon QuickSight subscription.
     * The following arguments are optional:
     */
    public val notificationEmail: Output<String>
        get() = javaResource.notificationEmail().applyValue({ args0 -> args0 })

    /**
     * Reader group associated with your Active Direcrtory.
     */
    public val readerGroups: Output<List<String>>?
        get() = javaResource.readerGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Realm of the Active Directory that is associated with your Amazon QuickSight account.
     */
    public val realm: Output<String>?
        get() = javaResource.realm().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object AccountSubscriptionMapper : ResourceMapper<AccountSubscription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.quicksight.AccountSubscription::class == javaResource::class

    override fun map(javaResource: Resource): AccountSubscription = AccountSubscription(
        javaResource
            as com.pulumi.aws.quicksight.AccountSubscription,
    )
}

/**
 * @see [AccountSubscription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccountSubscription].
 */
public suspend fun accountSubscription(
    name: String,
    block: suspend AccountSubscriptionResourceBuilder.() -> Unit,
): AccountSubscription {
    val builder = AccountSubscriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccountSubscription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accountSubscription(name: String): AccountSubscription {
    val builder = AccountSubscriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
