@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.AccountSubscriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS QuickSight Account Subscription.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.AccountSubscription;
 * import com.pulumi.aws.quicksight.AccountSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var subscription = new AccountSubscription("subscription", AccountSubscriptionArgs.builder()
 *             .accountName("quicksight-pulumi")
 *             .authenticationMethod("IAM_AND_QUICKSIGHT")
 *             .edition("ENTERPRISE")
 *             .notificationEmail("notification@email.com")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * You cannot import this resource.
 * @property accountName Name of your Amazon QuickSight account. This name is unique over all of AWS, and it appears only when users sign in.
 * @property activeDirectoryName Name of your Active Directory. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account.
 * @property adminGroups Admin group associated with your Active Directory. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account.
 * @property authenticationMethod Method that you want to use to authenticate your Amazon QuickSight account. Currently, the valid values for this parameter are `IAM_AND_QUICKSIGHT`, `IAM_ONLY`, and `ACTIVE_DIRECTORY`.
 * @property authorGroups Author group associated with your Active Directory.
 * @property awsAccountId AWS account ID hosting the QuickSight account. Default to provider account.
 * @property contactNumber A 10-digit phone number for the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
 * @property directoryId Active Directory ID that is associated with your Amazon QuickSight account.
 * @property edition Edition of Amazon QuickSight that you want your account to have. Currently, you can choose from `STANDARD`, `ENTERPRISE` or `ENTERPRISE_AND_Q`.
 * @property emailAddress Email address of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
 * @property firstName First name of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
 * @property lastName Last name of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
 * @property notificationEmail Email address that you want Amazon QuickSight to send notifications to regarding your Amazon QuickSight account or Amazon QuickSight subscription.
 * The following arguments are optional:
 * @property readerGroups Reader group associated with your Active Direcrtory.
 * @property realm Realm of the Active Directory that is associated with your Amazon QuickSight account.
 */
public data class AccountSubscriptionArgs(
    public val accountName: Output<String>? = null,
    public val activeDirectoryName: Output<String>? = null,
    public val adminGroups: Output<List<String>>? = null,
    public val authenticationMethod: Output<String>? = null,
    public val authorGroups: Output<List<String>>? = null,
    public val awsAccountId: Output<String>? = null,
    public val contactNumber: Output<String>? = null,
    public val directoryId: Output<String>? = null,
    public val edition: Output<String>? = null,
    public val emailAddress: Output<String>? = null,
    public val firstName: Output<String>? = null,
    public val lastName: Output<String>? = null,
    public val notificationEmail: Output<String>? = null,
    public val readerGroups: Output<List<String>>? = null,
    public val realm: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.AccountSubscriptionArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.AccountSubscriptionArgs =
        com.pulumi.aws.quicksight.AccountSubscriptionArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .activeDirectoryName(activeDirectoryName?.applyValue({ args0 -> args0 }))
            .adminGroups(adminGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .authenticationMethod(authenticationMethod?.applyValue({ args0 -> args0 }))
            .authorGroups(authorGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .awsAccountId(awsAccountId?.applyValue({ args0 -> args0 }))
            .contactNumber(contactNumber?.applyValue({ args0 -> args0 }))
            .directoryId(directoryId?.applyValue({ args0 -> args0 }))
            .edition(edition?.applyValue({ args0 -> args0 }))
            .emailAddress(emailAddress?.applyValue({ args0 -> args0 }))
            .firstName(firstName?.applyValue({ args0 -> args0 }))
            .lastName(lastName?.applyValue({ args0 -> args0 }))
            .notificationEmail(notificationEmail?.applyValue({ args0 -> args0 }))
            .readerGroups(readerGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .realm(realm?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccountSubscriptionArgs].
 */
@PulumiTagMarker
public class AccountSubscriptionArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var activeDirectoryName: Output<String>? = null

    private var adminGroups: Output<List<String>>? = null

    private var authenticationMethod: Output<String>? = null

    private var authorGroups: Output<List<String>>? = null

    private var awsAccountId: Output<String>? = null

    private var contactNumber: Output<String>? = null

    private var directoryId: Output<String>? = null

    private var edition: Output<String>? = null

    private var emailAddress: Output<String>? = null

    private var firstName: Output<String>? = null

    private var lastName: Output<String>? = null

    private var notificationEmail: Output<String>? = null

    private var readerGroups: Output<List<String>>? = null

    private var realm: Output<String>? = null

    /**
     * @param value Name of your Amazon QuickSight account. This name is unique over all of AWS, and it appears only when users sign in.
     */
    @JvmName("einfotsefmdkknao")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Name of your Active Directory. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account.
     */
    @JvmName("swgetcucoohjlvhq")
    public suspend fun activeDirectoryName(`value`: Output<String>) {
        this.activeDirectoryName = value
    }

    /**
     * @param value Admin group associated with your Active Directory. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account.
     */
    @JvmName("umscitvfgwwgtxkk")
    public suspend fun adminGroups(`value`: Output<List<String>>) {
        this.adminGroups = value
    }

    @JvmName("fnciocdgiuhtgiab")
    public suspend fun adminGroups(vararg values: Output<String>) {
        this.adminGroups = Output.all(values.asList())
    }

    /**
     * @param values Admin group associated with your Active Directory. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account.
     */
    @JvmName("ivvtyspcjknuiben")
    public suspend fun adminGroups(values: List<Output<String>>) {
        this.adminGroups = Output.all(values)
    }

    /**
     * @param value Method that you want to use to authenticate your Amazon QuickSight account. Currently, the valid values for this parameter are `IAM_AND_QUICKSIGHT`, `IAM_ONLY`, and `ACTIVE_DIRECTORY`.
     */
    @JvmName("dmarxtxaafdaqcrf")
    public suspend fun authenticationMethod(`value`: Output<String>) {
        this.authenticationMethod = value
    }

    /**
     * @param value Author group associated with your Active Directory.
     */
    @JvmName("mlgngbyqpfferfhk")
    public suspend fun authorGroups(`value`: Output<List<String>>) {
        this.authorGroups = value
    }

    @JvmName("dfmwjosdpailuxgm")
    public suspend fun authorGroups(vararg values: Output<String>) {
        this.authorGroups = Output.all(values.asList())
    }

    /**
     * @param values Author group associated with your Active Directory.
     */
    @JvmName("sapbcvnwsdwirigt")
    public suspend fun authorGroups(values: List<Output<String>>) {
        this.authorGroups = Output.all(values)
    }

    /**
     * @param value AWS account ID hosting the QuickSight account. Default to provider account.
     */
    @JvmName("mscpdknjxjuhbtai")
    public suspend fun awsAccountId(`value`: Output<String>) {
        this.awsAccountId = value
    }

    /**
     * @param value A 10-digit phone number for the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
     */
    @JvmName("jyjpfqlkxkyjusti")
    public suspend fun contactNumber(`value`: Output<String>) {
        this.contactNumber = value
    }

    /**
     * @param value Active Directory ID that is associated with your Amazon QuickSight account.
     */
    @JvmName("mdpdgtjcfjirkjww")
    public suspend fun directoryId(`value`: Output<String>) {
        this.directoryId = value
    }

    /**
     * @param value Edition of Amazon QuickSight that you want your account to have. Currently, you can choose from `STANDARD`, `ENTERPRISE` or `ENTERPRISE_AND_Q`.
     */
    @JvmName("thopvxrlgjevrlco")
    public suspend fun edition(`value`: Output<String>) {
        this.edition = value
    }

    /**
     * @param value Email address of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
     */
    @JvmName("fkqqbgyrisoskmhu")
    public suspend fun emailAddress(`value`: Output<String>) {
        this.emailAddress = value
    }

    /**
     * @param value First name of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
     */
    @JvmName("grfljrjabiwrfpxu")
    public suspend fun firstName(`value`: Output<String>) {
        this.firstName = value
    }

    /**
     * @param value Last name of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
     */
    @JvmName("wxfacblhnfmtjbhw")
    public suspend fun lastName(`value`: Output<String>) {
        this.lastName = value
    }

    /**
     * @param value Email address that you want Amazon QuickSight to send notifications to regarding your Amazon QuickSight account or Amazon QuickSight subscription.
     * The following arguments are optional:
     */
    @JvmName("womdjcumrnwhtuvn")
    public suspend fun notificationEmail(`value`: Output<String>) {
        this.notificationEmail = value
    }

    /**
     * @param value Reader group associated with your Active Direcrtory.
     */
    @JvmName("ifaqxevstgdneenp")
    public suspend fun readerGroups(`value`: Output<List<String>>) {
        this.readerGroups = value
    }

    @JvmName("glvimvkreuysddhb")
    public suspend fun readerGroups(vararg values: Output<String>) {
        this.readerGroups = Output.all(values.asList())
    }

    /**
     * @param values Reader group associated with your Active Direcrtory.
     */
    @JvmName("dcgmlbtgwntpkapf")
    public suspend fun readerGroups(values: List<Output<String>>) {
        this.readerGroups = Output.all(values)
    }

    /**
     * @param value Realm of the Active Directory that is associated with your Amazon QuickSight account.
     */
    @JvmName("ejvcdcvgyvtsvpvl")
    public suspend fun realm(`value`: Output<String>) {
        this.realm = value
    }

    /**
     * @param value Name of your Amazon QuickSight account. This name is unique over all of AWS, and it appears only when users sign in.
     */
    @JvmName("lwhjcflninjrxuwp")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Name of your Active Directory. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account.
     */
    @JvmName("rrurfenhxnperysq")
    public suspend fun activeDirectoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activeDirectoryName = mapped
    }

    /**
     * @param value Admin group associated with your Active Directory. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account.
     */
    @JvmName("imobcyqyxhrwffgl")
    public suspend fun adminGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminGroups = mapped
    }

    /**
     * @param values Admin group associated with your Active Directory. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account.
     */
    @JvmName("vipaamiruolipsxh")
    public suspend fun adminGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.adminGroups = mapped
    }

    /**
     * @param value Method that you want to use to authenticate your Amazon QuickSight account. Currently, the valid values for this parameter are `IAM_AND_QUICKSIGHT`, `IAM_ONLY`, and `ACTIVE_DIRECTORY`.
     */
    @JvmName("pehlqmiqcawensrg")
    public suspend fun authenticationMethod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationMethod = mapped
    }

    /**
     * @param value Author group associated with your Active Directory.
     */
    @JvmName("ncklsbyvrkgeaiow")
    public suspend fun authorGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorGroups = mapped
    }

    /**
     * @param values Author group associated with your Active Directory.
     */
    @JvmName("opwmcsqqkobshjcq")
    public suspend fun authorGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorGroups = mapped
    }

    /**
     * @param value AWS account ID hosting the QuickSight account. Default to provider account.
     */
    @JvmName("iklkvjuxcymibuiq")
    public suspend fun awsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsAccountId = mapped
    }

    /**
     * @param value A 10-digit phone number for the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
     */
    @JvmName("vmoprlbxyeuyvujc")
    public suspend fun contactNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactNumber = mapped
    }

    /**
     * @param value Active Directory ID that is associated with your Amazon QuickSight account.
     */
    @JvmName("dovpswrwuhhhseoj")
    public suspend fun directoryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryId = mapped
    }

    /**
     * @param value Edition of Amazon QuickSight that you want your account to have. Currently, you can choose from `STANDARD`, `ENTERPRISE` or `ENTERPRISE_AND_Q`.
     */
    @JvmName("dlnvimfaerrjbhhv")
    public suspend fun edition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.edition = mapped
    }

    /**
     * @param value Email address of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
     */
    @JvmName("kghnkcdjxhagpxij")
    public suspend fun emailAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailAddress = mapped
    }

    /**
     * @param value First name of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
     */
    @JvmName("mspxdrgwcuuaugyn")
    public suspend fun firstName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firstName = mapped
    }

    /**
     * @param value Last name of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
     */
    @JvmName("exndrkkwqiethwct")
    public suspend fun lastName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastName = mapped
    }

    /**
     * @param value Email address that you want Amazon QuickSight to send notifications to regarding your Amazon QuickSight account or Amazon QuickSight subscription.
     * The following arguments are optional:
     */
    @JvmName("xaphktkvdtkmfyru")
    public suspend fun notificationEmail(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationEmail = mapped
    }

    /**
     * @param value Reader group associated with your Active Direcrtory.
     */
    @JvmName("gjqvimqaeyiirjju")
    public suspend fun readerGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readerGroups = mapped
    }

    /**
     * @param values Reader group associated with your Active Direcrtory.
     */
    @JvmName("ubabwpuepckcnrlq")
    public suspend fun readerGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.readerGroups = mapped
    }

    /**
     * @param value Realm of the Active Directory that is associated with your Amazon QuickSight account.
     */
    @JvmName("mqtfrcrgwaugajdo")
    public suspend fun realm(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.realm = mapped
    }

    internal fun build(): AccountSubscriptionArgs = AccountSubscriptionArgs(
        accountName = accountName,
        activeDirectoryName = activeDirectoryName,
        adminGroups = adminGroups,
        authenticationMethod = authenticationMethod,
        authorGroups = authorGroups,
        awsAccountId = awsAccountId,
        contactNumber = contactNumber,
        directoryId = directoryId,
        edition = edition,
        emailAddress = emailAddress,
        firstName = firstName,
        lastName = lastName,
        notificationEmail = notificationEmail,
        readerGroups = readerGroups,
        realm = realm,
    )
}
