@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.AnalysisArgs.builder
import com.pulumi.aws.quicksight.kotlin.inputs.AnalysisParametersArgs
import com.pulumi.aws.quicksight.kotlin.inputs.AnalysisParametersArgsBuilder
import com.pulumi.aws.quicksight.kotlin.inputs.AnalysisPermissionArgs
import com.pulumi.aws.quicksight.kotlin.inputs.AnalysisPermissionArgsBuilder
import com.pulumi.aws.quicksight.kotlin.inputs.AnalysisSourceEntityArgs
import com.pulumi.aws.quicksight.kotlin.inputs.AnalysisSourceEntityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing a QuickSight Analysis.
 * ## Example Usage
 * ### From Source Template
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Analysis;
 * import com.pulumi.aws.quicksight.AnalysisArgs;
 * import com.pulumi.aws.quicksight.inputs.AnalysisSourceEntityArgs;
 * import com.pulumi.aws.quicksight.inputs.AnalysisSourceEntitySourceTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Analysis("example", AnalysisArgs.builder()
 *             .analysisId("example-id")
 *             .sourceEntity(AnalysisSourceEntityArgs.builder()
 *                 .sourceTemplate(AnalysisSourceEntitySourceTemplateArgs.builder()
 *                     .arn(aws_quicksight_template.source().arn())
 *                     .dataSetReferences(AnalysisSourceEntitySourceTemplateDataSetReferenceArgs.builder()
 *                         .dataSetArn(aws_quicksight_data_set.dataset().arn())
 *                         .dataSetPlaceholder("1")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Definition
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Analysis;
 * import com.pulumi.aws.quicksight.AnalysisArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Analysis("example", AnalysisArgs.builder()
 *             .analysisId("example-id")
 *             .definition(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import a QuickSight Analysis using the AWS account ID and analysis ID separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:quicksight/analysis:Analysis example 123456789012,example-id
 * ```
 * @property analysisId Identifier for the analysis.
 * @property awsAccountId AWS account ID.
 * @property name Display name for the analysis.
 * The following arguments are optional:
 * @property parameters The parameters for the creation of the analysis, which you want to use to override the default settings. An analysis can have any type of parameters, and some parameters might accept multiple values. See parameters.
 * @property permissions A set of resource permissions on the analysis. Maximum of 64 items. See permissions.
 * @property recoveryWindowInDays A value that specifies the number of days that Amazon QuickSight waits before it deletes the analysis. Use `0` to force deletion without recovery. Minimum value of `7`. Maximum value of `30`. Default to `30`.
 * @property sourceEntity The entity that you are using as a source when you create the analysis (template). Only one of `definition` or `source_entity` should be configured. See source_entity.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property themeArn The Amazon Resource Name (ARN) of the theme that is being used for this analysis. The theme ARN must exist in the same AWS account where you create the analysis.
 */
public data class AnalysisArgs(
    public val analysisId: Output<String>? = null,
    public val awsAccountId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val parameters: Output<AnalysisParametersArgs>? = null,
    public val permissions: Output<List<AnalysisPermissionArgs>>? = null,
    public val recoveryWindowInDays: Output<Int>? = null,
    public val sourceEntity: Output<AnalysisSourceEntityArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val themeArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.AnalysisArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.AnalysisArgs =
        com.pulumi.aws.quicksight.AnalysisArgs.builder()
            .analysisId(analysisId?.applyValue({ args0 -> args0 }))
            .awsAccountId(awsAccountId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .parameters(parameters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .permissions(
                permissions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .recoveryWindowInDays(recoveryWindowInDays?.applyValue({ args0 -> args0 }))
            .sourceEntity(sourceEntity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .themeArn(themeArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AnalysisArgs].
 */
@PulumiTagMarker
public class AnalysisArgsBuilder internal constructor() {
    private var analysisId: Output<String>? = null

    private var awsAccountId: Output<String>? = null

    private var name: Output<String>? = null

    private var parameters: Output<AnalysisParametersArgs>? = null

    private var permissions: Output<List<AnalysisPermissionArgs>>? = null

    private var recoveryWindowInDays: Output<Int>? = null

    private var sourceEntity: Output<AnalysisSourceEntityArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var themeArn: Output<String>? = null

    /**
     * @param value Identifier for the analysis.
     */
    @JvmName("knusuflppwfasajy")
    public suspend fun analysisId(`value`: Output<String>) {
        this.analysisId = value
    }

    /**
     * @param value AWS account ID.
     */
    @JvmName("qnjbtpjqtnmrecfb")
    public suspend fun awsAccountId(`value`: Output<String>) {
        this.awsAccountId = value
    }

    /**
     * @param value Display name for the analysis.
     * The following arguments are optional:
     */
    @JvmName("gbpmgbxjomxtnecw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The parameters for the creation of the analysis, which you want to use to override the default settings. An analysis can have any type of parameters, and some parameters might accept multiple values. See parameters.
     */
    @JvmName("pgfaphahlcxysoty")
    public suspend fun parameters(`value`: Output<AnalysisParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value A set of resource permissions on the analysis. Maximum of 64 items. See permissions.
     */
    @JvmName("xciceynqajojafwq")
    public suspend fun permissions(`value`: Output<List<AnalysisPermissionArgs>>) {
        this.permissions = value
    }

    @JvmName("dxrqqhocpeigxvll")
    public suspend fun permissions(vararg values: Output<AnalysisPermissionArgs>) {
        this.permissions = Output.all(values.asList())
    }

    /**
     * @param values A set of resource permissions on the analysis. Maximum of 64 items. See permissions.
     */
    @JvmName("ppkxhjrafasiuyow")
    public suspend fun permissions(values: List<Output<AnalysisPermissionArgs>>) {
        this.permissions = Output.all(values)
    }

    /**
     * @param value A value that specifies the number of days that Amazon QuickSight waits before it deletes the analysis. Use `0` to force deletion without recovery. Minimum value of `7`. Maximum value of `30`. Default to `30`.
     */
    @JvmName("pqutahtfqthsdvtn")
    public suspend fun recoveryWindowInDays(`value`: Output<Int>) {
        this.recoveryWindowInDays = value
    }

    /**
     * @param value The entity that you are using as a source when you create the analysis (template). Only one of `definition` or `source_entity` should be configured. See source_entity.
     */
    @JvmName("nxltldxxybthfubf")
    public suspend fun sourceEntity(`value`: Output<AnalysisSourceEntityArgs>) {
        this.sourceEntity = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ekappjwgsutduunc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the theme that is being used for this analysis. The theme ARN must exist in the same AWS account where you create the analysis.
     */
    @JvmName("tbeycmugqwdarttl")
    public suspend fun themeArn(`value`: Output<String>) {
        this.themeArn = value
    }

    /**
     * @param value Identifier for the analysis.
     */
    @JvmName("gknkdbriigbtoxhq")
    public suspend fun analysisId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.analysisId = mapped
    }

    /**
     * @param value AWS account ID.
     */
    @JvmName("ejbactnxxebdunsi")
    public suspend fun awsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsAccountId = mapped
    }

    /**
     * @param value Display name for the analysis.
     * The following arguments are optional:
     */
    @JvmName("uqatqqhkixmekgst")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The parameters for the creation of the analysis, which you want to use to override the default settings. An analysis can have any type of parameters, and some parameters might accept multiple values. See parameters.
     */
    @JvmName("ksluthkegicihalc")
    public suspend fun parameters(`value`: AnalysisParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The parameters for the creation of the analysis, which you want to use to override the default settings. An analysis can have any type of parameters, and some parameters might accept multiple values. See parameters.
     */
    @JvmName("sjjajiqytywvfwcf")
    public suspend fun parameters(argument: suspend AnalysisParametersArgsBuilder.() -> Unit) {
        val toBeMapped = AnalysisParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param value A set of resource permissions on the analysis. Maximum of 64 items. See permissions.
     */
    @JvmName("nuqcxcipthmufsyo")
    public suspend fun permissions(`value`: List<AnalysisPermissionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param argument A set of resource permissions on the analysis. Maximum of 64 items. See permissions.
     */
    @JvmName("gjutcpgauldtogtd")
    public suspend fun permissions(argument: List<suspend AnalysisPermissionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AnalysisPermissionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param argument A set of resource permissions on the analysis. Maximum of 64 items. See permissions.
     */
    @JvmName("cgtpfnqxeiuxcqmq")
    public suspend fun permissions(
        vararg
        argument: suspend AnalysisPermissionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AnalysisPermissionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param argument A set of resource permissions on the analysis. Maximum of 64 items. See permissions.
     */
    @JvmName("djjrwkbubejokthg")
    public suspend fun permissions(argument: suspend AnalysisPermissionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AnalysisPermissionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param values A set of resource permissions on the analysis. Maximum of 64 items. See permissions.
     */
    @JvmName("xmkgajqlautqekuv")
    public suspend fun permissions(vararg values: AnalysisPermissionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param value A value that specifies the number of days that Amazon QuickSight waits before it deletes the analysis. Use `0` to force deletion without recovery. Minimum value of `7`. Maximum value of `30`. Default to `30`.
     */
    @JvmName("icpkjrdqhuyahjmc")
    public suspend fun recoveryWindowInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryWindowInDays = mapped
    }

    /**
     * @param value The entity that you are using as a source when you create the analysis (template). Only one of `definition` or `source_entity` should be configured. See source_entity.
     */
    @JvmName("nitrqkhslyiybfla")
    public suspend fun sourceEntity(`value`: AnalysisSourceEntityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEntity = mapped
    }

    /**
     * @param argument The entity that you are using as a source when you create the analysis (template). Only one of `definition` or `source_entity` should be configured. See source_entity.
     */
    @JvmName("ttdqxexrlslkdtiy")
    public suspend fun sourceEntity(argument: suspend AnalysisSourceEntityArgsBuilder.() -> Unit) {
        val toBeMapped = AnalysisSourceEntityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceEntity = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jjfrxhakrlguqsrf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("haackctplapncjqo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the theme that is being used for this analysis. The theme ARN must exist in the same AWS account where you create the analysis.
     */
    @JvmName("pfhmoutgtldoluya")
    public suspend fun themeArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.themeArn = mapped
    }

    internal fun build(): AnalysisArgs = AnalysisArgs(
        analysisId = analysisId,
        awsAccountId = awsAccountId,
        name = name,
        parameters = parameters,
        permissions = permissions,
        recoveryWindowInDays = recoveryWindowInDays,
        sourceEntity = sourceEntity,
        tags = tags,
        themeArn = themeArn,
    )
}
