@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.DashboardArgs.builder
import com.pulumi.aws.quicksight.kotlin.inputs.DashboardDashboardPublishOptionsArgs
import com.pulumi.aws.quicksight.kotlin.inputs.DashboardDashboardPublishOptionsArgsBuilder
import com.pulumi.aws.quicksight.kotlin.inputs.DashboardParametersArgs
import com.pulumi.aws.quicksight.kotlin.inputs.DashboardParametersArgsBuilder
import com.pulumi.aws.quicksight.kotlin.inputs.DashboardPermissionArgs
import com.pulumi.aws.quicksight.kotlin.inputs.DashboardPermissionArgsBuilder
import com.pulumi.aws.quicksight.kotlin.inputs.DashboardSourceEntityArgs
import com.pulumi.aws.quicksight.kotlin.inputs.DashboardSourceEntityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing a QuickSight Dashboard.
 * ## Example Usage
 * ### From Source Template
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Dashboard;
 * import com.pulumi.aws.quicksight.DashboardArgs;
 * import com.pulumi.aws.quicksight.inputs.DashboardSourceEntityArgs;
 * import com.pulumi.aws.quicksight.inputs.DashboardSourceEntitySourceTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Dashboard("example", DashboardArgs.builder()
 *             .dashboardId("example-id")
 *             .versionDescription("version")
 *             .sourceEntity(DashboardSourceEntityArgs.builder()
 *                 .sourceTemplate(DashboardSourceEntitySourceTemplateArgs.builder()
 *                     .arn(aws_quicksight_template.source().arn())
 *                     .dataSetReferences(DashboardSourceEntitySourceTemplateDataSetReferenceArgs.builder()
 *                         .dataSetArn(aws_quicksight_data_set.dataset().arn())
 *                         .dataSetPlaceholder("1")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Definition
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Dashboard;
 * import com.pulumi.aws.quicksight.DashboardArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Dashboard("example", DashboardArgs.builder()
 *             .dashboardId("example-id")
 *             .versionDescription("version")
 *             .definition(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import a QuickSight Dashboard using the AWS account ID and dashboard ID separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:quicksight/dashboard:Dashboard example 123456789012,example-id
 * ```
 * @property awsAccountId AWS account ID.
 * @property dashboardId Identifier for the dashboard.
 * @property dashboardPublishOptions Options for publishing the dashboard. See dashboard_publish_options.
 * @property name Display name for the dashboard.
 * @property parameters The parameters for the creation of the dashboard, which you want to use to override the default settings. A dashboard can have any type of parameters, and some parameters might accept multiple values. See parameters.
 * @property permissions A set of resource permissions on the dashboard. Maximum of 64 items. See permissions.
 * @property sourceEntity The entity that you are using as a source when you create the dashboard (template). Only one of `definition` or `source_entity` should be configured. See source_entity.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property themeArn The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. The theme ARN must exist in the same AWS account where you create the dashboard.
 * @property versionDescription A description of the current dashboard version being created/updated.
 * The following arguments are optional:
 */
public data class DashboardArgs(
    public val awsAccountId: Output<String>? = null,
    public val dashboardId: Output<String>? = null,
    public val dashboardPublishOptions: Output<DashboardDashboardPublishOptionsArgs>? = null,
    public val name: Output<String>? = null,
    public val parameters: Output<DashboardParametersArgs>? = null,
    public val permissions: Output<List<DashboardPermissionArgs>>? = null,
    public val sourceEntity: Output<DashboardSourceEntityArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val themeArn: Output<String>? = null,
    public val versionDescription: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.DashboardArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.DashboardArgs =
        com.pulumi.aws.quicksight.DashboardArgs.builder()
            .awsAccountId(awsAccountId?.applyValue({ args0 -> args0 }))
            .dashboardId(dashboardId?.applyValue({ args0 -> args0 }))
            .dashboardPublishOptions(
                dashboardPublishOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .parameters(parameters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .permissions(
                permissions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sourceEntity(sourceEntity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .themeArn(themeArn?.applyValue({ args0 -> args0 }))
            .versionDescription(versionDescription?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DashboardArgs].
 */
@PulumiTagMarker
public class DashboardArgsBuilder internal constructor() {
    private var awsAccountId: Output<String>? = null

    private var dashboardId: Output<String>? = null

    private var dashboardPublishOptions: Output<DashboardDashboardPublishOptionsArgs>? = null

    private var name: Output<String>? = null

    private var parameters: Output<DashboardParametersArgs>? = null

    private var permissions: Output<List<DashboardPermissionArgs>>? = null

    private var sourceEntity: Output<DashboardSourceEntityArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var themeArn: Output<String>? = null

    private var versionDescription: Output<String>? = null

    /**
     * @param value AWS account ID.
     */
    @JvmName("qqixfcxthlbmbbus")
    public suspend fun awsAccountId(`value`: Output<String>) {
        this.awsAccountId = value
    }

    /**
     * @param value Identifier for the dashboard.
     */
    @JvmName("oogpynfukwdhjbvl")
    public suspend fun dashboardId(`value`: Output<String>) {
        this.dashboardId = value
    }

    /**
     * @param value Options for publishing the dashboard. See dashboard_publish_options.
     */
    @JvmName("cqrgbadpoxcciice")
    public suspend
    fun dashboardPublishOptions(`value`: Output<DashboardDashboardPublishOptionsArgs>) {
        this.dashboardPublishOptions = value
    }

    /**
     * @param value Display name for the dashboard.
     */
    @JvmName("oyspmvbgetinbsrk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The parameters for the creation of the dashboard, which you want to use to override the default settings. A dashboard can have any type of parameters, and some parameters might accept multiple values. See parameters.
     */
    @JvmName("nsmycqkdoldhubvi")
    public suspend fun parameters(`value`: Output<DashboardParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value A set of resource permissions on the dashboard. Maximum of 64 items. See permissions.
     */
    @JvmName("bkboundtdfdqiwcs")
    public suspend fun permissions(`value`: Output<List<DashboardPermissionArgs>>) {
        this.permissions = value
    }

    @JvmName("qwuvpckjenylfvej")
    public suspend fun permissions(vararg values: Output<DashboardPermissionArgs>) {
        this.permissions = Output.all(values.asList())
    }

    /**
     * @param values A set of resource permissions on the dashboard. Maximum of 64 items. See permissions.
     */
    @JvmName("pqowpfpbelhjjxxg")
    public suspend fun permissions(values: List<Output<DashboardPermissionArgs>>) {
        this.permissions = Output.all(values)
    }

    /**
     * @param value The entity that you are using as a source when you create the dashboard (template). Only one of `definition` or `source_entity` should be configured. See source_entity.
     */
    @JvmName("esljkswpvguiriau")
    public suspend fun sourceEntity(`value`: Output<DashboardSourceEntityArgs>) {
        this.sourceEntity = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yglupyfmsnqtebtl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. The theme ARN must exist in the same AWS account where you create the dashboard.
     */
    @JvmName("bfjppvegpmphovxs")
    public suspend fun themeArn(`value`: Output<String>) {
        this.themeArn = value
    }

    /**
     * @param value A description of the current dashboard version being created/updated.
     * The following arguments are optional:
     */
    @JvmName("avdmjeaqddnmnatb")
    public suspend fun versionDescription(`value`: Output<String>) {
        this.versionDescription = value
    }

    /**
     * @param value AWS account ID.
     */
    @JvmName("bijyjltyctmhfgni")
    public suspend fun awsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsAccountId = mapped
    }

    /**
     * @param value Identifier for the dashboard.
     */
    @JvmName("ftxpebtfwejrawhg")
    public suspend fun dashboardId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dashboardId = mapped
    }

    /**
     * @param value Options for publishing the dashboard. See dashboard_publish_options.
     */
    @JvmName("xdawyaqlytpmhtdw")
    public suspend fun dashboardPublishOptions(`value`: DashboardDashboardPublishOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dashboardPublishOptions = mapped
    }

    /**
     * @param argument Options for publishing the dashboard. See dashboard_publish_options.
     */
    @JvmName("wsrsstkxcipipumc")
    public suspend
    fun dashboardPublishOptions(argument: suspend DashboardDashboardPublishOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = DashboardDashboardPublishOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dashboardPublishOptions = mapped
    }

    /**
     * @param value Display name for the dashboard.
     */
    @JvmName("jowcogvxnwqrudpt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The parameters for the creation of the dashboard, which you want to use to override the default settings. A dashboard can have any type of parameters, and some parameters might accept multiple values. See parameters.
     */
    @JvmName("dvcauyhgcmhbxqlj")
    public suspend fun parameters(`value`: DashboardParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The parameters for the creation of the dashboard, which you want to use to override the default settings. A dashboard can have any type of parameters, and some parameters might accept multiple values. See parameters.
     */
    @JvmName("dsdkxxulhfvvpqey")
    public suspend fun parameters(argument: suspend DashboardParametersArgsBuilder.() -> Unit) {
        val toBeMapped = DashboardParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param value A set of resource permissions on the dashboard. Maximum of 64 items. See permissions.
     */
    @JvmName("ymdmscnqglfdgxws")
    public suspend fun permissions(`value`: List<DashboardPermissionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param argument A set of resource permissions on the dashboard. Maximum of 64 items. See permissions.
     */
    @JvmName("eamcqgiyvnwpbghs")
    public suspend
    fun permissions(argument: List<suspend DashboardPermissionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DashboardPermissionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param argument A set of resource permissions on the dashboard. Maximum of 64 items. See permissions.
     */
    @JvmName("rvcvhxoucsnergcr")
    public suspend fun permissions(
        vararg
        argument: suspend DashboardPermissionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DashboardPermissionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param argument A set of resource permissions on the dashboard. Maximum of 64 items. See permissions.
     */
    @JvmName("ijmlxicabpcrveqp")
    public suspend fun permissions(argument: suspend DashboardPermissionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DashboardPermissionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param values A set of resource permissions on the dashboard. Maximum of 64 items. See permissions.
     */
    @JvmName("dcgvnuyxieqjcdxo")
    public suspend fun permissions(vararg values: DashboardPermissionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param value The entity that you are using as a source when you create the dashboard (template). Only one of `definition` or `source_entity` should be configured. See source_entity.
     */
    @JvmName("fmywnqaspagthcxq")
    public suspend fun sourceEntity(`value`: DashboardSourceEntityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEntity = mapped
    }

    /**
     * @param argument The entity that you are using as a source when you create the dashboard (template). Only one of `definition` or `source_entity` should be configured. See source_entity.
     */
    @JvmName("kymqblinbaplvukv")
    public suspend fun sourceEntity(argument: suspend DashboardSourceEntityArgsBuilder.() -> Unit) {
        val toBeMapped = DashboardSourceEntityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceEntity = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ndnsuijumtovffyy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("turohubccfaillfn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. The theme ARN must exist in the same AWS account where you create the dashboard.
     */
    @JvmName("edqohliqdekbfjkn")
    public suspend fun themeArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.themeArn = mapped
    }

    /**
     * @param value A description of the current dashboard version being created/updated.
     * The following arguments are optional:
     */
    @JvmName("uflmfjgedoyiruly")
    public suspend fun versionDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionDescription = mapped
    }

    internal fun build(): DashboardArgs = DashboardArgs(
        awsAccountId = awsAccountId,
        dashboardId = dashboardId,
        dashboardPublishOptions = dashboardPublishOptions,
        name = name,
        parameters = parameters,
        permissions = permissions,
        sourceEntity = sourceEntity,
        tags = tags,
        themeArn = themeArn,
        versionDescription = versionDescription,
    )
}
