@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.DataSetArgs.builder
import com.pulumi.aws.quicksight.kotlin.inputs.DataSetColumnGroupArgs
import com.pulumi.aws.quicksight.kotlin.inputs.DataSetColumnGroupArgsBuilder
import com.pulumi.aws.quicksight.kotlin.inputs.DataSetColumnLevelPermissionRuleArgs
import com.pulumi.aws.quicksight.kotlin.inputs.DataSetColumnLevelPermissionRuleArgsBuilder
import com.pulumi.aws.quicksight.kotlin.inputs.DataSetDataSetUsageConfigurationArgs
import com.pulumi.aws.quicksight.kotlin.inputs.DataSetDataSetUsageConfigurationArgsBuilder
import com.pulumi.aws.quicksight.kotlin.inputs.DataSetFieldFolderArgs
import com.pulumi.aws.quicksight.kotlin.inputs.DataSetFieldFolderArgsBuilder
import com.pulumi.aws.quicksight.kotlin.inputs.DataSetLogicalTableMapArgs
import com.pulumi.aws.quicksight.kotlin.inputs.DataSetLogicalTableMapArgsBuilder
import com.pulumi.aws.quicksight.kotlin.inputs.DataSetPermissionArgs
import com.pulumi.aws.quicksight.kotlin.inputs.DataSetPermissionArgsBuilder
import com.pulumi.aws.quicksight.kotlin.inputs.DataSetPhysicalTableMapArgs
import com.pulumi.aws.quicksight.kotlin.inputs.DataSetPhysicalTableMapArgsBuilder
import com.pulumi.aws.quicksight.kotlin.inputs.DataSetRefreshPropertiesArgs
import com.pulumi.aws.quicksight.kotlin.inputs.DataSetRefreshPropertiesArgsBuilder
import com.pulumi.aws.quicksight.kotlin.inputs.DataSetRowLevelPermissionDataSetArgs
import com.pulumi.aws.quicksight.kotlin.inputs.DataSetRowLevelPermissionDataSetArgsBuilder
import com.pulumi.aws.quicksight.kotlin.inputs.DataSetRowLevelPermissionTagConfigurationArgs
import com.pulumi.aws.quicksight.kotlin.inputs.DataSetRowLevelPermissionTagConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing a QuickSight Data Set.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.DataSet;
 * import com.pulumi.aws.quicksight.DataSetArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapS3SourceArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapS3SourceUploadSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSet("example", DataSetArgs.builder()
 *             .dataSetId("example-id")
 *             .importMode("SPICE")
 *             .physicalTableMaps(DataSetPhysicalTableMapArgs.builder()
 *                 .physicalTableMapId("example-id")
 *                 .s3Source(DataSetPhysicalTableMapS3SourceArgs.builder()
 *                     .dataSourceArn(aws_quicksight_data_source.example().arn())
 *                     .inputColumns(DataSetPhysicalTableMapS3SourceInputColumnArgs.builder()
 *                         .name("Column1")
 *                         .type("STRING")
 *                         .build())
 *                     .uploadSettings(DataSetPhysicalTableMapS3SourceUploadSettingsArgs.builder()
 *                         .format("JSON")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Column Level Permission Rules
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.DataSet;
 * import com.pulumi.aws.quicksight.DataSetArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapS3SourceArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapS3SourceUploadSettingsArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetColumnLevelPermissionRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSet("example", DataSetArgs.builder()
 *             .dataSetId("example-id")
 *             .importMode("SPICE")
 *             .physicalTableMaps(DataSetPhysicalTableMapArgs.builder()
 *                 .physicalTableMapId("example-id")
 *                 .s3Source(DataSetPhysicalTableMapS3SourceArgs.builder()
 *                     .dataSourceArn(aws_quicksight_data_source.example().arn())
 *                     .inputColumns(DataSetPhysicalTableMapS3SourceInputColumnArgs.builder()
 *                         .name("Column1")
 *                         .type("STRING")
 *                         .build())
 *                     .uploadSettings(DataSetPhysicalTableMapS3SourceUploadSettingsArgs.builder()
 *                         .format("JSON")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .columnLevelPermissionRules(DataSetColumnLevelPermissionRuleArgs.builder()
 *                 .columnNames("Column1")
 *                 .principals(aws_quicksight_user.example().arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Field Folders
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.DataSet;
 * import com.pulumi.aws.quicksight.DataSetArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapS3SourceArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapS3SourceUploadSettingsArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetFieldFolderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSet("example", DataSetArgs.builder()
 *             .dataSetId("example-id")
 *             .importMode("SPICE")
 *             .physicalTableMaps(DataSetPhysicalTableMapArgs.builder()
 *                 .physicalTableMapId("example-id")
 *                 .s3Source(DataSetPhysicalTableMapS3SourceArgs.builder()
 *                     .dataSourceArn(aws_quicksight_data_source.example().arn())
 *                     .inputColumns(DataSetPhysicalTableMapS3SourceInputColumnArgs.builder()
 *                         .name("Column1")
 *                         .type("STRING")
 *                         .build())
 *                     .uploadSettings(DataSetPhysicalTableMapS3SourceUploadSettingsArgs.builder()
 *                         .format("JSON")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .fieldFolders(DataSetFieldFolderArgs.builder()
 *                 .fieldFoldersId("example-id")
 *                 .columns("Column1")
 *                 .description("example description")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Permissions
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.DataSet;
 * import com.pulumi.aws.quicksight.DataSetArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapS3SourceArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapS3SourceUploadSettingsArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSet("example", DataSetArgs.builder()
 *             .dataSetId("example-id")
 *             .importMode("SPICE")
 *             .physicalTableMaps(DataSetPhysicalTableMapArgs.builder()
 *                 .physicalTableMapId("example-id")
 *                 .s3Source(DataSetPhysicalTableMapS3SourceArgs.builder()
 *                     .dataSourceArn(aws_quicksight_data_source.example().arn())
 *                     .inputColumns(DataSetPhysicalTableMapS3SourceInputColumnArgs.builder()
 *                         .name("Column1")
 *                         .type("STRING")
 *                         .build())
 *                     .uploadSettings(DataSetPhysicalTableMapS3SourceUploadSettingsArgs.builder()
 *                         .format("JSON")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .permissions(DataSetPermissionArgs.builder()
 *                 .actions(
 *                     "quicksight:DescribeDataSet",
 *                     "quicksight:DescribeDataSetPermissions",
 *                     "quicksight:PassDataSet",
 *                     "quicksight:DescribeIngestion",
 *                     "quicksight:ListIngestions")
 *                 .principal(aws_quicksight_user.example().arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Row Level Permission Tag Configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.DataSet;
 * import com.pulumi.aws.quicksight.DataSetArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapS3SourceArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapS3SourceUploadSettingsArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetRowLevelPermissionTagConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSet("example", DataSetArgs.builder()
 *             .dataSetId("example-id")
 *             .importMode("SPICE")
 *             .physicalTableMaps(DataSetPhysicalTableMapArgs.builder()
 *                 .physicalTableMapId("example-id")
 *                 .s3Source(DataSetPhysicalTableMapS3SourceArgs.builder()
 *                     .dataSourceArn(aws_quicksight_data_source.example().arn())
 *                     .inputColumns(DataSetPhysicalTableMapS3SourceInputColumnArgs.builder()
 *                         .name("Column1")
 *                         .type("STRING")
 *                         .build())
 *                     .uploadSettings(DataSetPhysicalTableMapS3SourceUploadSettingsArgs.builder()
 *                         .format("JSON")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .rowLevelPermissionTagConfiguration(DataSetRowLevelPermissionTagConfigurationArgs.builder()
 *                 .status("ENABLED")
 *                 .tagRules(DataSetRowLevelPermissionTagConfigurationTagRuleArgs.builder()
 *                     .columnName("Column1")
 *                     .tagKey("tagkey")
 *                     .matchAllValue("*")
 *                     .tagMultiValueDelimiter(",")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import a QuickSight Data Set using the AWS account ID and data set ID separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:quicksight/dataSet:DataSet example 123456789012,example-id
 * ```
 * @property awsAccountId AWS account ID.
 * @property columnGroups Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported. See column_groups.
 * @property columnLevelPermissionRules A set of 1 or more definitions of a [ColumnLevelPermissionRule](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html). See column_level_permission_rules.
 * @property dataSetId Identifier for the data set.
 * @property dataSetUsageConfiguration The usage configuration to apply to child datasets that reference this dataset as a source. See data_set_usage_configuration.
 * @property fieldFolders The folder that contains fields and nested subfolders for your dataset. See field_folders.
 * @property importMode Indicates whether you want to import the data into SPICE. Valid values are `SPICE` and `DIRECT_QUERY`.
 * @property logicalTableMaps Configures the combination and transformation of the data from the physical tables. Maximum of 1 entry. See logical_table_map.
 * @property name Display name for the dataset.
 * @property permissions A set of resource permissions on the data source. Maximum of 64 items. See permissions.
 * @property physicalTableMaps Declares the physical tables that are available in the underlying data sources. See physical_table_map.
 * The following arguments are optional:
 * @property refreshProperties The refresh properties for the data set. **NOTE**: Only valid when `import_mode` is set to `SPICE`. See refresh_properties.
 * @property rowLevelPermissionDataSet The row-level security configuration for the data that you want to create. See row_level_permission_data_set.
 * @property rowLevelPermissionTagConfiguration The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported for anonymous embedding only. See row_level_permission_tag_configuration.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class DataSetArgs(
    public val awsAccountId: Output<String>? = null,
    public val columnGroups: Output<List<DataSetColumnGroupArgs>>? = null,
    public val columnLevelPermissionRules: Output<List<DataSetColumnLevelPermissionRuleArgs>>? = null,
    public val dataSetId: Output<String>? = null,
    public val dataSetUsageConfiguration: Output<DataSetDataSetUsageConfigurationArgs>? = null,
    public val fieldFolders: Output<List<DataSetFieldFolderArgs>>? = null,
    public val importMode: Output<String>? = null,
    public val logicalTableMaps: Output<List<DataSetLogicalTableMapArgs>>? = null,
    public val name: Output<String>? = null,
    public val permissions: Output<List<DataSetPermissionArgs>>? = null,
    public val physicalTableMaps: Output<List<DataSetPhysicalTableMapArgs>>? = null,
    public val refreshProperties: Output<DataSetRefreshPropertiesArgs>? = null,
    public val rowLevelPermissionDataSet: Output<DataSetRowLevelPermissionDataSetArgs>? = null,
    public val rowLevelPermissionTagConfiguration:
    Output<DataSetRowLevelPermissionTagConfigurationArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.DataSetArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.DataSetArgs =
        com.pulumi.aws.quicksight.DataSetArgs.builder()
            .awsAccountId(awsAccountId?.applyValue({ args0 -> args0 }))
            .columnGroups(
                columnGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .columnLevelPermissionRules(
                columnLevelPermissionRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .dataSetId(dataSetId?.applyValue({ args0 -> args0 }))
            .dataSetUsageConfiguration(
                dataSetUsageConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .fieldFolders(
                fieldFolders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .importMode(importMode?.applyValue({ args0 -> args0 }))
            .logicalTableMaps(
                logicalTableMaps?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .permissions(
                permissions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .physicalTableMaps(
                physicalTableMaps?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .refreshProperties(refreshProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .rowLevelPermissionDataSet(
                rowLevelPermissionDataSet?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .rowLevelPermissionTagConfiguration(
                rowLevelPermissionTagConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DataSetArgs].
 */
@PulumiTagMarker
public class DataSetArgsBuilder internal constructor() {
    private var awsAccountId: Output<String>? = null

    private var columnGroups: Output<List<DataSetColumnGroupArgs>>? = null

    private var columnLevelPermissionRules: Output<List<DataSetColumnLevelPermissionRuleArgs>>? = null

    private var dataSetId: Output<String>? = null

    private var dataSetUsageConfiguration: Output<DataSetDataSetUsageConfigurationArgs>? = null

    private var fieldFolders: Output<List<DataSetFieldFolderArgs>>? = null

    private var importMode: Output<String>? = null

    private var logicalTableMaps: Output<List<DataSetLogicalTableMapArgs>>? = null

    private var name: Output<String>? = null

    private var permissions: Output<List<DataSetPermissionArgs>>? = null

    private var physicalTableMaps: Output<List<DataSetPhysicalTableMapArgs>>? = null

    private var refreshProperties: Output<DataSetRefreshPropertiesArgs>? = null

    private var rowLevelPermissionDataSet: Output<DataSetRowLevelPermissionDataSetArgs>? = null

    private var rowLevelPermissionTagConfiguration:
        Output<DataSetRowLevelPermissionTagConfigurationArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value AWS account ID.
     */
    @JvmName("jwgpqdunbmwduxdk")
    public suspend fun awsAccountId(`value`: Output<String>) {
        this.awsAccountId = value
    }

    /**
     * @param value Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported. See column_groups.
     */
    @JvmName("ctxxnudnisbmpcto")
    public suspend fun columnGroups(`value`: Output<List<DataSetColumnGroupArgs>>) {
        this.columnGroups = value
    }

    @JvmName("arssfgwmcbpngiyy")
    public suspend fun columnGroups(vararg values: Output<DataSetColumnGroupArgs>) {
        this.columnGroups = Output.all(values.asList())
    }

    /**
     * @param values Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported. See column_groups.
     */
    @JvmName("ucjvbxuxvofkdqfb")
    public suspend fun columnGroups(values: List<Output<DataSetColumnGroupArgs>>) {
        this.columnGroups = Output.all(values)
    }

    /**
     * @param value A set of 1 or more definitions of a [ColumnLevelPermissionRule](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html). See column_level_permission_rules.
     */
    @JvmName("koxhqqfdcyyywnen")
    public suspend
    fun columnLevelPermissionRules(`value`: Output<List<DataSetColumnLevelPermissionRuleArgs>>) {
        this.columnLevelPermissionRules = value
    }

    @JvmName("dayciribxfyvpuln")
    public suspend fun columnLevelPermissionRules(
        vararg
        values: Output<DataSetColumnLevelPermissionRuleArgs>,
    ) {
        this.columnLevelPermissionRules = Output.all(values.asList())
    }

    /**
     * @param values A set of 1 or more definitions of a [ColumnLevelPermissionRule](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html). See column_level_permission_rules.
     */
    @JvmName("hotgxvvlboyyuqnq")
    public suspend
    fun columnLevelPermissionRules(values: List<Output<DataSetColumnLevelPermissionRuleArgs>>) {
        this.columnLevelPermissionRules = Output.all(values)
    }

    /**
     * @param value Identifier for the data set.
     */
    @JvmName("nquwogqmcmrqaolu")
    public suspend fun dataSetId(`value`: Output<String>) {
        this.dataSetId = value
    }

    /**
     * @param value The usage configuration to apply to child datasets that reference this dataset as a source. See data_set_usage_configuration.
     */
    @JvmName("lxnwxnvbulohudsa")
    public suspend
    fun dataSetUsageConfiguration(`value`: Output<DataSetDataSetUsageConfigurationArgs>) {
        this.dataSetUsageConfiguration = value
    }

    /**
     * @param value The folder that contains fields and nested subfolders for your dataset. See field_folders.
     */
    @JvmName("sdmfxscddlqppxuq")
    public suspend fun fieldFolders(`value`: Output<List<DataSetFieldFolderArgs>>) {
        this.fieldFolders = value
    }

    @JvmName("cgiixhloeaakifio")
    public suspend fun fieldFolders(vararg values: Output<DataSetFieldFolderArgs>) {
        this.fieldFolders = Output.all(values.asList())
    }

    /**
     * @param values The folder that contains fields and nested subfolders for your dataset. See field_folders.
     */
    @JvmName("nxgpdrgjvwcknvum")
    public suspend fun fieldFolders(values: List<Output<DataSetFieldFolderArgs>>) {
        this.fieldFolders = Output.all(values)
    }

    /**
     * @param value Indicates whether you want to import the data into SPICE. Valid values are `SPICE` and `DIRECT_QUERY`.
     */
    @JvmName("mpkrpjmbhtvhhbnw")
    public suspend fun importMode(`value`: Output<String>) {
        this.importMode = value
    }

    /**
     * @param value Configures the combination and transformation of the data from the physical tables. Maximum of 1 entry. See logical_table_map.
     */
    @JvmName("uhqscviqqbacflqi")
    public suspend fun logicalTableMaps(`value`: Output<List<DataSetLogicalTableMapArgs>>) {
        this.logicalTableMaps = value
    }

    @JvmName("rvgoytrvbppgikuo")
    public suspend fun logicalTableMaps(vararg values: Output<DataSetLogicalTableMapArgs>) {
        this.logicalTableMaps = Output.all(values.asList())
    }

    /**
     * @param values Configures the combination and transformation of the data from the physical tables. Maximum of 1 entry. See logical_table_map.
     */
    @JvmName("fvuqygrpmexyavuy")
    public suspend fun logicalTableMaps(values: List<Output<DataSetLogicalTableMapArgs>>) {
        this.logicalTableMaps = Output.all(values)
    }

    /**
     * @param value Display name for the dataset.
     */
    @JvmName("ivonjtsnivtvqplw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A set of resource permissions on the data source. Maximum of 64 items. See permissions.
     */
    @JvmName("mtulgadvvoabpcta")
    public suspend fun permissions(`value`: Output<List<DataSetPermissionArgs>>) {
        this.permissions = value
    }

    @JvmName("potslghxktaslfgg")
    public suspend fun permissions(vararg values: Output<DataSetPermissionArgs>) {
        this.permissions = Output.all(values.asList())
    }

    /**
     * @param values A set of resource permissions on the data source. Maximum of 64 items. See permissions.
     */
    @JvmName("svqcaorjfwvmlydg")
    public suspend fun permissions(values: List<Output<DataSetPermissionArgs>>) {
        this.permissions = Output.all(values)
    }

    /**
     * @param value Declares the physical tables that are available in the underlying data sources. See physical_table_map.
     * The following arguments are optional:
     */
    @JvmName("tpkltorjrxcnculf")
    public suspend fun physicalTableMaps(`value`: Output<List<DataSetPhysicalTableMapArgs>>) {
        this.physicalTableMaps = value
    }

    @JvmName("ixiclvqbpycpqyls")
    public suspend fun physicalTableMaps(vararg values: Output<DataSetPhysicalTableMapArgs>) {
        this.physicalTableMaps = Output.all(values.asList())
    }

    /**
     * @param values Declares the physical tables that are available in the underlying data sources. See physical_table_map.
     * The following arguments are optional:
     */
    @JvmName("nmsrtrwquiipwluf")
    public suspend fun physicalTableMaps(values: List<Output<DataSetPhysicalTableMapArgs>>) {
        this.physicalTableMaps = Output.all(values)
    }

    /**
     * @param value The refresh properties for the data set. **NOTE**: Only valid when `import_mode` is set to `SPICE`. See refresh_properties.
     */
    @JvmName("gkgvhqwstrxhfsyx")
    public suspend fun refreshProperties(`value`: Output<DataSetRefreshPropertiesArgs>) {
        this.refreshProperties = value
    }

    /**
     * @param value The row-level security configuration for the data that you want to create. See row_level_permission_data_set.
     */
    @JvmName("cstqihyeipostrnq")
    public suspend
    fun rowLevelPermissionDataSet(`value`: Output<DataSetRowLevelPermissionDataSetArgs>) {
        this.rowLevelPermissionDataSet = value
    }

    /**
     * @param value The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported for anonymous embedding only. See row_level_permission_tag_configuration.
     */
    @JvmName("avirfahgealyswib")
    public suspend
    fun rowLevelPermissionTagConfiguration(`value`: Output<DataSetRowLevelPermissionTagConfigurationArgs>) {
        this.rowLevelPermissionTagConfiguration = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("incfpoexcgjnlwvn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value AWS account ID.
     */
    @JvmName("rvyfjorgexccqcmo")
    public suspend fun awsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsAccountId = mapped
    }

    /**
     * @param value Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported. See column_groups.
     */
    @JvmName("cweliravwwrhsbyc")
    public suspend fun columnGroups(`value`: List<DataSetColumnGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columnGroups = mapped
    }

    /**
     * @param argument Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported. See column_groups.
     */
    @JvmName("tqtoeifbqgqnoiye")
    public suspend
    fun columnGroups(argument: List<suspend DataSetColumnGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataSetColumnGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.columnGroups = mapped
    }

    /**
     * @param argument Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported. See column_groups.
     */
    @JvmName("ibiwiincjaouutrn")
    public suspend fun columnGroups(
        vararg
        argument: suspend DataSetColumnGroupArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DataSetColumnGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.columnGroups = mapped
    }

    /**
     * @param argument Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported. See column_groups.
     */
    @JvmName("cuukfdiqftdeejmc")
    public suspend fun columnGroups(argument: suspend DataSetColumnGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DataSetColumnGroupArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.columnGroups = mapped
    }

    /**
     * @param values Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported. See column_groups.
     */
    @JvmName("yeqfheuxldrnhqtd")
    public suspend fun columnGroups(vararg values: DataSetColumnGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columnGroups = mapped
    }

    /**
     * @param value A set of 1 or more definitions of a [ColumnLevelPermissionRule](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html). See column_level_permission_rules.
     */
    @JvmName("rnlnvqbtkfkumvyo")
    public suspend
    fun columnLevelPermissionRules(`value`: List<DataSetColumnLevelPermissionRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columnLevelPermissionRules = mapped
    }

    /**
     * @param argument A set of 1 or more definitions of a [ColumnLevelPermissionRule](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html). See column_level_permission_rules.
     */
    @JvmName("fsbiwjrivimbthae")
    public suspend
    fun columnLevelPermissionRules(argument: List<suspend DataSetColumnLevelPermissionRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataSetColumnLevelPermissionRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.columnLevelPermissionRules = mapped
    }

    /**
     * @param argument A set of 1 or more definitions of a [ColumnLevelPermissionRule](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html). See column_level_permission_rules.
     */
    @JvmName("audupjidkyvdoutn")
    public suspend fun columnLevelPermissionRules(
        vararg
        argument: suspend DataSetColumnLevelPermissionRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DataSetColumnLevelPermissionRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.columnLevelPermissionRules = mapped
    }

    /**
     * @param argument A set of 1 or more definitions of a [ColumnLevelPermissionRule](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html). See column_level_permission_rules.
     */
    @JvmName("xdicvmklhfegdtvo")
    public suspend
    fun columnLevelPermissionRules(argument: suspend DataSetColumnLevelPermissionRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DataSetColumnLevelPermissionRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.columnLevelPermissionRules = mapped
    }

    /**
     * @param values A set of 1 or more definitions of a [ColumnLevelPermissionRule](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html). See column_level_permission_rules.
     */
    @JvmName("ldtnxbmolvrmtsfn")
    public suspend fun columnLevelPermissionRules(
        vararg
        values: DataSetColumnLevelPermissionRuleArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columnLevelPermissionRules = mapped
    }

    /**
     * @param value Identifier for the data set.
     */
    @JvmName("xhgqciftpsetydln")
    public suspend fun dataSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSetId = mapped
    }

    /**
     * @param value The usage configuration to apply to child datasets that reference this dataset as a source. See data_set_usage_configuration.
     */
    @JvmName("mokervdprqhkxnex")
    public suspend fun dataSetUsageConfiguration(`value`: DataSetDataSetUsageConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSetUsageConfiguration = mapped
    }

    /**
     * @param argument The usage configuration to apply to child datasets that reference this dataset as a source. See data_set_usage_configuration.
     */
    @JvmName("jymbhhidmrpdsxqq")
    public suspend
    fun dataSetUsageConfiguration(argument: suspend DataSetDataSetUsageConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DataSetDataSetUsageConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dataSetUsageConfiguration = mapped
    }

    /**
     * @param value The folder that contains fields and nested subfolders for your dataset. See field_folders.
     */
    @JvmName("buvfcpmafrvukufk")
    public suspend fun fieldFolders(`value`: List<DataSetFieldFolderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fieldFolders = mapped
    }

    /**
     * @param argument The folder that contains fields and nested subfolders for your dataset. See field_folders.
     */
    @JvmName("bbyqdqnjquqohock")
    public suspend
    fun fieldFolders(argument: List<suspend DataSetFieldFolderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataSetFieldFolderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.fieldFolders = mapped
    }

    /**
     * @param argument The folder that contains fields and nested subfolders for your dataset. See field_folders.
     */
    @JvmName("mrgxfngmhgwdfvtx")
    public suspend fun fieldFolders(
        vararg
        argument: suspend DataSetFieldFolderArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DataSetFieldFolderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.fieldFolders = mapped
    }

    /**
     * @param argument The folder that contains fields and nested subfolders for your dataset. See field_folders.
     */
    @JvmName("pnaeghdikyobvrpt")
    public suspend fun fieldFolders(argument: suspend DataSetFieldFolderArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DataSetFieldFolderArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.fieldFolders = mapped
    }

    /**
     * @param values The folder that contains fields and nested subfolders for your dataset. See field_folders.
     */
    @JvmName("guqklchgbnldamvk")
    public suspend fun fieldFolders(vararg values: DataSetFieldFolderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fieldFolders = mapped
    }

    /**
     * @param value Indicates whether you want to import the data into SPICE. Valid values are `SPICE` and `DIRECT_QUERY`.
     */
    @JvmName("ohxntmlsdlhvwdje")
    public suspend fun importMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.importMode = mapped
    }

    /**
     * @param value Configures the combination and transformation of the data from the physical tables. Maximum of 1 entry. See logical_table_map.
     */
    @JvmName("rpmcevidbbmrmqhl")
    public suspend fun logicalTableMaps(`value`: List<DataSetLogicalTableMapArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logicalTableMaps = mapped
    }

    /**
     * @param argument Configures the combination and transformation of the data from the physical tables. Maximum of 1 entry. See logical_table_map.
     */
    @JvmName("eoemqpqoavrbkpbn")
    public suspend
    fun logicalTableMaps(argument: List<suspend DataSetLogicalTableMapArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataSetLogicalTableMapArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.logicalTableMaps = mapped
    }

    /**
     * @param argument Configures the combination and transformation of the data from the physical tables. Maximum of 1 entry. See logical_table_map.
     */
    @JvmName("kwbrfsvggtuyaxgh")
    public suspend fun logicalTableMaps(
        vararg
        argument: suspend DataSetLogicalTableMapArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DataSetLogicalTableMapArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.logicalTableMaps = mapped
    }

    /**
     * @param argument Configures the combination and transformation of the data from the physical tables. Maximum of 1 entry. See logical_table_map.
     */
    @JvmName("qinveqylfygboelc")
    public suspend
    fun logicalTableMaps(argument: suspend DataSetLogicalTableMapArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DataSetLogicalTableMapArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.logicalTableMaps = mapped
    }

    /**
     * @param values Configures the combination and transformation of the data from the physical tables. Maximum of 1 entry. See logical_table_map.
     */
    @JvmName("hmqykawjgidcjaxp")
    public suspend fun logicalTableMaps(vararg values: DataSetLogicalTableMapArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logicalTableMaps = mapped
    }

    /**
     * @param value Display name for the dataset.
     */
    @JvmName("ifuguuhlddufkcyg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A set of resource permissions on the data source. Maximum of 64 items. See permissions.
     */
    @JvmName("dxbktmmehtjomncm")
    public suspend fun permissions(`value`: List<DataSetPermissionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param argument A set of resource permissions on the data source. Maximum of 64 items. See permissions.
     */
    @JvmName("ipjxgluoruwfgrwy")
    public suspend fun permissions(argument: List<suspend DataSetPermissionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataSetPermissionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param argument A set of resource permissions on the data source. Maximum of 64 items. See permissions.
     */
    @JvmName("bmospkxiubumomha")
    public suspend fun permissions(vararg argument: suspend DataSetPermissionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DataSetPermissionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param argument A set of resource permissions on the data source. Maximum of 64 items. See permissions.
     */
    @JvmName("isrrctgutxoulcnr")
    public suspend fun permissions(argument: suspend DataSetPermissionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DataSetPermissionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param values A set of resource permissions on the data source. Maximum of 64 items. See permissions.
     */
    @JvmName("jsousmjnqnxiixvy")
    public suspend fun permissions(vararg values: DataSetPermissionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param value Declares the physical tables that are available in the underlying data sources. See physical_table_map.
     * The following arguments are optional:
     */
    @JvmName("wglbwctwpqjyucin")
    public suspend fun physicalTableMaps(`value`: List<DataSetPhysicalTableMapArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.physicalTableMaps = mapped
    }

    /**
     * @param argument Declares the physical tables that are available in the underlying data sources. See physical_table_map.
     * The following arguments are optional:
     */
    @JvmName("isseevtbxcydkuye")
    public suspend
    fun physicalTableMaps(argument: List<suspend DataSetPhysicalTableMapArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataSetPhysicalTableMapArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.physicalTableMaps = mapped
    }

    /**
     * @param argument Declares the physical tables that are available in the underlying data sources. See physical_table_map.
     * The following arguments are optional:
     */
    @JvmName("ixxhqovhdxscwcao")
    public suspend fun physicalTableMaps(
        vararg
        argument: suspend DataSetPhysicalTableMapArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DataSetPhysicalTableMapArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.physicalTableMaps = mapped
    }

    /**
     * @param argument Declares the physical tables that are available in the underlying data sources. See physical_table_map.
     * The following arguments are optional:
     */
    @JvmName("yjkhvrlsbfgifbcs")
    public suspend
    fun physicalTableMaps(argument: suspend DataSetPhysicalTableMapArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DataSetPhysicalTableMapArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.physicalTableMaps = mapped
    }

    /**
     * @param values Declares the physical tables that are available in the underlying data sources. See physical_table_map.
     * The following arguments are optional:
     */
    @JvmName("vvuarvrgriblbvjw")
    public suspend fun physicalTableMaps(vararg values: DataSetPhysicalTableMapArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.physicalTableMaps = mapped
    }

    /**
     * @param value The refresh properties for the data set. **NOTE**: Only valid when `import_mode` is set to `SPICE`. See refresh_properties.
     */
    @JvmName("xrqndbvmingtxakf")
    public suspend fun refreshProperties(`value`: DataSetRefreshPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.refreshProperties = mapped
    }

    /**
     * @param argument The refresh properties for the data set. **NOTE**: Only valid when `import_mode` is set to `SPICE`. See refresh_properties.
     */
    @JvmName("pltfcxvkciuyfvdr")
    public suspend
    fun refreshProperties(argument: suspend DataSetRefreshPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DataSetRefreshPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.refreshProperties = mapped
    }

    /**
     * @param value The row-level security configuration for the data that you want to create. See row_level_permission_data_set.
     */
    @JvmName("dxvdioljywmfkrdu")
    public suspend fun rowLevelPermissionDataSet(`value`: DataSetRowLevelPermissionDataSetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rowLevelPermissionDataSet = mapped
    }

    /**
     * @param argument The row-level security configuration for the data that you want to create. See row_level_permission_data_set.
     */
    @JvmName("akpmlefrvkduagoy")
    public suspend
    fun rowLevelPermissionDataSet(argument: suspend DataSetRowLevelPermissionDataSetArgsBuilder.() -> Unit) {
        val toBeMapped = DataSetRowLevelPermissionDataSetArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.rowLevelPermissionDataSet = mapped
    }

    /**
     * @param value The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported for anonymous embedding only. See row_level_permission_tag_configuration.
     */
    @JvmName("ibadftybucuqgamj")
    public suspend
    fun rowLevelPermissionTagConfiguration(`value`: DataSetRowLevelPermissionTagConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rowLevelPermissionTagConfiguration = mapped
    }

    /**
     * @param argument The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported for anonymous embedding only. See row_level_permission_tag_configuration.
     */
    @JvmName("cmiflfnabebxaldi")
    public suspend
    fun rowLevelPermissionTagConfiguration(argument: suspend DataSetRowLevelPermissionTagConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DataSetRowLevelPermissionTagConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.rowLevelPermissionTagConfiguration = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vtatfkcgbascomww")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rvslbylrnvbcqjcw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DataSetArgs = DataSetArgs(
        awsAccountId = awsAccountId,
        columnGroups = columnGroups,
        columnLevelPermissionRules = columnLevelPermissionRules,
        dataSetId = dataSetId,
        dataSetUsageConfiguration = dataSetUsageConfiguration,
        fieldFolders = fieldFolders,
        importMode = importMode,
        logicalTableMaps = logicalTableMaps,
        name = name,
        permissions = permissions,
        physicalTableMaps = physicalTableMaps,
        refreshProperties = refreshProperties,
        rowLevelPermissionDataSet = rowLevelPermissionDataSet,
        rowLevelPermissionTagConfiguration = rowLevelPermissionTagConfiguration,
        tags = tags,
    )
}
