@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.FolderArgs.builder
import com.pulumi.aws.quicksight.kotlin.inputs.FolderPermissionArgs
import com.pulumi.aws.quicksight.kotlin.inputs.FolderPermissionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing a QuickSight Folder.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Folder;
 * import com.pulumi.aws.quicksight.FolderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Folder("example", FolderArgs.builder()
 *             .folderId("example-id")
 *             .build());
 *     }
 * }
 * ```
 * ### With Permissions
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Folder;
 * import com.pulumi.aws.quicksight.FolderArgs;
 * import com.pulumi.aws.quicksight.inputs.FolderPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Folder("example", FolderArgs.builder()
 *             .folderId("example-id")
 *             .permissions(FolderPermissionArgs.builder()
 *                 .actions(
 *                     "quicksight:CreateFolder",
 *                     "quicksight:DescribeFolder",
 *                     "quicksight:UpdateFolder",
 *                     "quicksight:DeleteFolder",
 *                     "quicksight:CreateFolderMembership",
 *                     "quicksight:DeleteFolderMembership",
 *                     "quicksight:DescribeFolderPermissions",
 *                     "quicksight:UpdateFolderPermissions")
 *                 .principal(aws_quicksight_user.example().arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Parent Folder
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Folder;
 * import com.pulumi.aws.quicksight.FolderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var parent = new Folder("parent", FolderArgs.builder()
 *             .folderId("parent-id")
 *             .build());
 *         var example = new Folder("example", FolderArgs.builder()
 *             .folderId("example-id")
 *             .parentFolderArn(parent.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import a QuickSight folder using the AWS account ID and folder ID name separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:quicksight/folder:Folder example 123456789012,example-id
 * ```
 * @property awsAccountId AWS account ID.
 * @property folderId Identifier for the folder.
 * @property folderType The type of folder. By default, it is `SHARED`. Valid values are: `SHARED`.
 * @property name Display name for the folder.
 * The following arguments are optional:
 * @property parentFolderArn The Amazon Resource Name (ARN) for the parent folder. If not set, creates a root-level folder.
 * @property permissions A set of resource permissions on the folder. Maximum of 64 items. See permissions.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class FolderArgs(
    public val awsAccountId: Output<String>? = null,
    public val folderId: Output<String>? = null,
    public val folderType: Output<String>? = null,
    public val name: Output<String>? = null,
    public val parentFolderArn: Output<String>? = null,
    public val permissions: Output<List<FolderPermissionArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.FolderArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.FolderArgs =
        com.pulumi.aws.quicksight.FolderArgs.builder()
            .awsAccountId(awsAccountId?.applyValue({ args0 -> args0 }))
            .folderId(folderId?.applyValue({ args0 -> args0 }))
            .folderType(folderType?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .parentFolderArn(parentFolderArn?.applyValue({ args0 -> args0 }))
            .permissions(
                permissions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FolderArgs].
 */
@PulumiTagMarker
public class FolderArgsBuilder internal constructor() {
    private var awsAccountId: Output<String>? = null

    private var folderId: Output<String>? = null

    private var folderType: Output<String>? = null

    private var name: Output<String>? = null

    private var parentFolderArn: Output<String>? = null

    private var permissions: Output<List<FolderPermissionArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value AWS account ID.
     */
    @JvmName("wwrgmvwpmdcqrlpi")
    public suspend fun awsAccountId(`value`: Output<String>) {
        this.awsAccountId = value
    }

    /**
     * @param value Identifier for the folder.
     */
    @JvmName("jysakxekopylfxxu")
    public suspend fun folderId(`value`: Output<String>) {
        this.folderId = value
    }

    /**
     * @param value The type of folder. By default, it is `SHARED`. Valid values are: `SHARED`.
     */
    @JvmName("hprhhyjuvhoeuwyw")
    public suspend fun folderType(`value`: Output<String>) {
        this.folderType = value
    }

    /**
     * @param value Display name for the folder.
     * The following arguments are optional:
     */
    @JvmName("tcmieapgbocxfnod")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) for the parent folder. If not set, creates a root-level folder.
     */
    @JvmName("pgovxtxtbclnfuiw")
    public suspend fun parentFolderArn(`value`: Output<String>) {
        this.parentFolderArn = value
    }

    /**
     * @param value A set of resource permissions on the folder. Maximum of 64 items. See permissions.
     */
    @JvmName("whhbqxumpyvkcamk")
    public suspend fun permissions(`value`: Output<List<FolderPermissionArgs>>) {
        this.permissions = value
    }

    @JvmName("trwdmadmomhybmjw")
    public suspend fun permissions(vararg values: Output<FolderPermissionArgs>) {
        this.permissions = Output.all(values.asList())
    }

    /**
     * @param values A set of resource permissions on the folder. Maximum of 64 items. See permissions.
     */
    @JvmName("rvhqkdqfnhdigjgh")
    public suspend fun permissions(values: List<Output<FolderPermissionArgs>>) {
        this.permissions = Output.all(values)
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tlpohtppypvqkwkv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value AWS account ID.
     */
    @JvmName("acrpeylnttqlimsy")
    public suspend fun awsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsAccountId = mapped
    }

    /**
     * @param value Identifier for the folder.
     */
    @JvmName("txhxhryetqahmvjn")
    public suspend fun folderId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folderId = mapped
    }

    /**
     * @param value The type of folder. By default, it is `SHARED`. Valid values are: `SHARED`.
     */
    @JvmName("ktklwompshqeiajn")
    public suspend fun folderType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folderType = mapped
    }

    /**
     * @param value Display name for the folder.
     * The following arguments are optional:
     */
    @JvmName("gbyiexohqmhahikb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) for the parent folder. If not set, creates a root-level folder.
     */
    @JvmName("mqymtponhvrdhnsa")
    public suspend fun parentFolderArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentFolderArn = mapped
    }

    /**
     * @param value A set of resource permissions on the folder. Maximum of 64 items. See permissions.
     */
    @JvmName("swyqdxrmhhblhalw")
    public suspend fun permissions(`value`: List<FolderPermissionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param argument A set of resource permissions on the folder. Maximum of 64 items. See permissions.
     */
    @JvmName("qvpbadjaotwwkpjn")
    public suspend fun permissions(argument: List<suspend FolderPermissionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FolderPermissionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param argument A set of resource permissions on the folder. Maximum of 64 items. See permissions.
     */
    @JvmName("ojlmrmllyubmxfgl")
    public suspend fun permissions(vararg argument: suspend FolderPermissionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FolderPermissionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param argument A set of resource permissions on the folder. Maximum of 64 items. See permissions.
     */
    @JvmName("hvjsatghofuwymfi")
    public suspend fun permissions(argument: suspend FolderPermissionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(FolderPermissionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param values A set of resource permissions on the folder. Maximum of 64 items. See permissions.
     */
    @JvmName("vesjjoovcijnyjus")
    public suspend fun permissions(vararg values: FolderPermissionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("csdkscwxxemutntm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rksqjeoywvrstwxo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FolderArgs = FolderArgs(
        awsAccountId = awsAccountId,
        folderId = folderId,
        folderType = folderType,
        name = name,
        parentFolderArn = parentFolderArn,
        permissions = permissions,
        tags = tags,
    )
}
