@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [FolderMembership].
 */
@PulumiTagMarker
public class FolderMembershipResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FolderMembershipArgs = FolderMembershipArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FolderMembershipArgsBuilder.() -> Unit) {
        val builder = FolderMembershipArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): FolderMembership {
        val builtJavaResource = com.pulumi.aws.quicksight.FolderMembership(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FolderMembership(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS QuickSight Folder Membership.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.FolderMembership;
 * import com.pulumi.aws.quicksight.FolderMembershipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FolderMembership("example", FolderMembershipArgs.builder()
 *             .folderId(aws_quicksight_folder.example().folder_id())
 *             .memberType("DATASET")
 *             .memberId(aws_quicksight_data_set.example().data_set_id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import QuickSight Folder Membership using the AWS account ID, folder ID, member type, and member ID separated by commas (`,`). For example:
 * ```sh
 *  $ pulumi import aws:quicksight/folderMembership:FolderMembership example 123456789012,example-folder,DATASET,example-dataset
 * ```
 *
 */
public class FolderMembership internal constructor(
    override val javaResource: com.pulumi.aws.quicksight.FolderMembership,
) : KotlinCustomResource(javaResource, FolderMembershipMapper) {
    /**
     * AWS account ID.
     */
    public val awsAccountId: Output<String>
        get() = javaResource.awsAccountId().applyValue({ args0 -> args0 })

    /**
     * Identifier for the folder.
     */
    public val folderId: Output<String>
        get() = javaResource.folderId().applyValue({ args0 -> args0 })

    /**
     * ID of the asset (the dashboard, analysis, or dataset).
     */
    public val memberId: Output<String>
        get() = javaResource.memberId().applyValue({ args0 -> args0 })

    /**
     * Type of the member. Valid values are `ANALYSIS`, `DASHBOARD`, and `DATASET`.
     * The following arguments are optional:
     */
    public val memberType: Output<String>
        get() = javaResource.memberType().applyValue({ args0 -> args0 })
}

public object FolderMembershipMapper : ResourceMapper<FolderMembership> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.quicksight.FolderMembership::class == javaResource::class

    override fun map(javaResource: Resource): FolderMembership = FolderMembership(
        javaResource as
            com.pulumi.aws.quicksight.FolderMembership,
    )
}

/**
 * @see [FolderMembership].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FolderMembership].
 */
public suspend fun folderMembership(
    name: String,
    block: suspend FolderMembershipResourceBuilder.() -> Unit,
): FolderMembership {
    val builder = FolderMembershipResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FolderMembership].
 * @param name The _unique_ name of the resulting resource.
 */
public fun folderMembership(name: String): FolderMembership {
    val builder = FolderMembershipResourceBuilder()
    builder.name(name)
    return builder.build()
}
