@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.FolderMembershipArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS QuickSight Folder Membership.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.FolderMembership;
 * import com.pulumi.aws.quicksight.FolderMembershipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FolderMembership("example", FolderMembershipArgs.builder()
 *             .folderId(aws_quicksight_folder.example().folder_id())
 *             .memberType("DATASET")
 *             .memberId(aws_quicksight_data_set.example().data_set_id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import QuickSight Folder Membership using the AWS account ID, folder ID, member type, and member ID separated by commas (`,`). For example:
 * ```sh
 *  $ pulumi import aws:quicksight/folderMembership:FolderMembership example 123456789012,example-folder,DATASET,example-dataset
 * ```
 * @property awsAccountId AWS account ID.
 * @property folderId Identifier for the folder.
 * @property memberId ID of the asset (the dashboard, analysis, or dataset).
 * @property memberType Type of the member. Valid values are `ANALYSIS`, `DASHBOARD`, and `DATASET`.
 * The following arguments are optional:
 */
public data class FolderMembershipArgs(
    public val awsAccountId: Output<String>? = null,
    public val folderId: Output<String>? = null,
    public val memberId: Output<String>? = null,
    public val memberType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.FolderMembershipArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.FolderMembershipArgs =
        com.pulumi.aws.quicksight.FolderMembershipArgs.builder()
            .awsAccountId(awsAccountId?.applyValue({ args0 -> args0 }))
            .folderId(folderId?.applyValue({ args0 -> args0 }))
            .memberId(memberId?.applyValue({ args0 -> args0 }))
            .memberType(memberType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FolderMembershipArgs].
 */
@PulumiTagMarker
public class FolderMembershipArgsBuilder internal constructor() {
    private var awsAccountId: Output<String>? = null

    private var folderId: Output<String>? = null

    private var memberId: Output<String>? = null

    private var memberType: Output<String>? = null

    /**
     * @param value AWS account ID.
     */
    @JvmName("pvuprneemmijviwj")
    public suspend fun awsAccountId(`value`: Output<String>) {
        this.awsAccountId = value
    }

    /**
     * @param value Identifier for the folder.
     */
    @JvmName("syhvfuqppdpqeyvk")
    public suspend fun folderId(`value`: Output<String>) {
        this.folderId = value
    }

    /**
     * @param value ID of the asset (the dashboard, analysis, or dataset).
     */
    @JvmName("dgxdskkwmrxamwtk")
    public suspend fun memberId(`value`: Output<String>) {
        this.memberId = value
    }

    /**
     * @param value Type of the member. Valid values are `ANALYSIS`, `DASHBOARD`, and `DATASET`.
     * The following arguments are optional:
     */
    @JvmName("gceotfbovhwcujim")
    public suspend fun memberType(`value`: Output<String>) {
        this.memberType = value
    }

    /**
     * @param value AWS account ID.
     */
    @JvmName("jjeslxxacgbldxxh")
    public suspend fun awsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsAccountId = mapped
    }

    /**
     * @param value Identifier for the folder.
     */
    @JvmName("frlwmhattpqgpxyi")
    public suspend fun folderId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folderId = mapped
    }

    /**
     * @param value ID of the asset (the dashboard, analysis, or dataset).
     */
    @JvmName("udbgaqnvepycrmck")
    public suspend fun memberId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memberId = mapped
    }

    /**
     * @param value Type of the member. Valid values are `ANALYSIS`, `DASHBOARD`, and `DATASET`.
     * The following arguments are optional:
     */
    @JvmName("sydmjeemqemrmovh")
    public suspend fun memberType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memberType = mapped
    }

    internal fun build(): FolderMembershipArgs = FolderMembershipArgs(
        awsAccountId = awsAccountId,
        folderId = folderId,
        memberId = memberId,
        memberType = memberType,
    )
}
