@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.GroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing QuickSight Group
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Group;
 * import com.pulumi.aws.quicksight.GroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Group("example", GroupArgs.builder()
 *             .groupName("tf-example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import QuickSight Group using the aws account id, namespace and group name separated by `/`. For example:
 * ```sh
 *  $ pulumi import aws:quicksight/group:Group example 123456789123/default/tf-example
 * ```
 * @property awsAccountId The ID for the AWS account that the group is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.
 * @property description A description for the group.
 * @property groupName A name for the group.
 * @property namespace The namespace. Currently, you should set this to `default`.
 */
public data class GroupArgs(
    public val awsAccountId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val groupName: Output<String>? = null,
    public val namespace: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.GroupArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.GroupArgs =
        com.pulumi.aws.quicksight.GroupArgs.builder()
            .awsAccountId(awsAccountId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .groupName(groupName?.applyValue({ args0 -> args0 }))
            .namespace(namespace?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupArgs].
 */
@PulumiTagMarker
public class GroupArgsBuilder internal constructor() {
    private var awsAccountId: Output<String>? = null

    private var description: Output<String>? = null

    private var groupName: Output<String>? = null

    private var namespace: Output<String>? = null

    /**
     * @param value The ID for the AWS account that the group is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.
     */
    @JvmName("sljhivfmcykohhbs")
    public suspend fun awsAccountId(`value`: Output<String>) {
        this.awsAccountId = value
    }

    /**
     * @param value A description for the group.
     */
    @JvmName("ertdafloiwxgvips")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A name for the group.
     */
    @JvmName("yjlvmdnrkeiofmrt")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value The namespace. Currently, you should set this to `default`.
     */
    @JvmName("ndswnaoswoeutsog")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value The ID for the AWS account that the group is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.
     */
    @JvmName("svwbtwhvlctjtkmq")
    public suspend fun awsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsAccountId = mapped
    }

    /**
     * @param value A description for the group.
     */
    @JvmName("uyeeaxqucknrtegw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A name for the group.
     */
    @JvmName("cjgscjmfmsvowvhv")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value The namespace. Currently, you should set this to `default`.
     */
    @JvmName("empnxengxkesfbid")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    internal fun build(): GroupArgs = GroupArgs(
        awsAccountId = awsAccountId,
        description = description,
        groupName = groupName,
        namespace = namespace,
    )
}
