@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.GroupMembershipArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing QuickSight Group Membership
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.GroupMembership;
 * import com.pulumi.aws.quicksight.GroupMembershipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GroupMembership("example", GroupMembershipArgs.builder()
 *             .groupName("all-access-users")
 *             .memberName("john_smith")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import QuickSight Group membership using the AWS account ID, namespace, group name and member name separated by `/`. For example:
 * ```sh
 *  $ pulumi import aws:quicksight/groupMembership:GroupMembership example 123456789123/default/all-access-users/john_smith
 * ```
 * @property awsAccountId The ID for the AWS account that the group is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.
 * @property groupName The name of the group in which the member will be added.
 * @property memberName The name of the member to add to the group.
 * @property namespace The namespace that you want the user to be a part of. Defaults to `default`.
 */
public data class GroupMembershipArgs(
    public val awsAccountId: Output<String>? = null,
    public val groupName: Output<String>? = null,
    public val memberName: Output<String>? = null,
    public val namespace: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.GroupMembershipArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.GroupMembershipArgs =
        com.pulumi.aws.quicksight.GroupMembershipArgs.builder()
            .awsAccountId(awsAccountId?.applyValue({ args0 -> args0 }))
            .groupName(groupName?.applyValue({ args0 -> args0 }))
            .memberName(memberName?.applyValue({ args0 -> args0 }))
            .namespace(namespace?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupMembershipArgs].
 */
@PulumiTagMarker
public class GroupMembershipArgsBuilder internal constructor() {
    private var awsAccountId: Output<String>? = null

    private var groupName: Output<String>? = null

    private var memberName: Output<String>? = null

    private var namespace: Output<String>? = null

    /**
     * @param value The ID for the AWS account that the group is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.
     */
    @JvmName("etudnwlvmjicpojq")
    public suspend fun awsAccountId(`value`: Output<String>) {
        this.awsAccountId = value
    }

    /**
     * @param value The name of the group in which the member will be added.
     */
    @JvmName("qkxfjucamwouakln")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value The name of the member to add to the group.
     */
    @JvmName("yfroqqylxidccinb")
    public suspend fun memberName(`value`: Output<String>) {
        this.memberName = value
    }

    /**
     * @param value The namespace that you want the user to be a part of. Defaults to `default`.
     */
    @JvmName("nkeubcayyvtbtlxv")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value The ID for the AWS account that the group is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.
     */
    @JvmName("bfxmyiahjueyrtkt")
    public suspend fun awsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsAccountId = mapped
    }

    /**
     * @param value The name of the group in which the member will be added.
     */
    @JvmName("gqcoedfrticexwrn")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value The name of the member to add to the group.
     */
    @JvmName("rcklofqcfwtjgjiq")
    public suspend fun memberName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memberName = mapped
    }

    /**
     * @param value The namespace that you want the user to be a part of. Defaults to `default`.
     */
    @JvmName("rfglnfaxegvhxfcp")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    internal fun build(): GroupMembershipArgs = GroupMembershipArgs(
        awsAccountId = awsAccountId,
        groupName = groupName,
        memberName = memberName,
        namespace = namespace,
    )
}
