@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.kotlin.outputs.IamPolicyAssignmentIdentities
import com.pulumi.aws.quicksight.kotlin.outputs.IamPolicyAssignmentIdentities.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [IamPolicyAssignment].
 */
@PulumiTagMarker
public class IamPolicyAssignmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IamPolicyAssignmentArgs = IamPolicyAssignmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IamPolicyAssignmentArgsBuilder.() -> Unit) {
        val builder = IamPolicyAssignmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): IamPolicyAssignment {
        val builtJavaResource = com.pulumi.aws.quicksight.IamPolicyAssignment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IamPolicyAssignment(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS QuickSight IAM Policy Assignment.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.IamPolicyAssignment;
 * import com.pulumi.aws.quicksight.IamPolicyAssignmentArgs;
 * import com.pulumi.aws.quicksight.inputs.IamPolicyAssignmentIdentitiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new IamPolicyAssignment("example", IamPolicyAssignmentArgs.builder()
 *             .assignmentName("example")
 *             .assignmentStatus("ENABLED")
 *             .policyArn(aws_iam_policy.example().arn())
 *             .identities(IamPolicyAssignmentIdentitiesArgs.builder()
 *                 .users(aws_quicksight_user.example().user_name())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import QuickSight IAM Policy Assignment using the AWS account ID, namespace, and assignment name separated by commas (`,`). For example:
 * ```sh
 *  $ pulumi import aws:quicksight/iamPolicyAssignment:IamPolicyAssignment example 123456789012,default,example
 * ```
 *
 */
public class IamPolicyAssignment internal constructor(
    override val javaResource: com.pulumi.aws.quicksight.IamPolicyAssignment,
) : KotlinCustomResource(javaResource, IamPolicyAssignmentMapper) {
    /**
     * Assignment ID.
     */
    public val assignmentId: Output<String>
        get() = javaResource.assignmentId().applyValue({ args0 -> args0 })

    /**
     * Name of the assignment.
     */
    public val assignmentName: Output<String>
        get() = javaResource.assignmentName().applyValue({ args0 -> args0 })

    /**
     * Status of the assignment. Valid values are `ENABLED`, `DISABLED`, and `DRAFT`.
     * The following arguments are optional:
     */
    public val assignmentStatus: Output<String>
        get() = javaResource.assignmentStatus().applyValue({ args0 -> args0 })

    /**
     * AWS account ID.
     */
    public val awsAccountId: Output<String>
        get() = javaResource.awsAccountId().applyValue({ args0 -> args0 })

    /**
     * Amazon QuickSight users, groups, or both to assign the policy to. See `identities`.
     */
    public val identities: Output<IamPolicyAssignmentIdentities>?
        get() = javaResource.identities().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Namespace that contains the assignment. Defaults to `default`.
     */
    public val namespace: Output<String>
        get() = javaResource.namespace().applyValue({ args0 -> args0 })

    /**
     * ARN of the IAM policy to apply to the Amazon QuickSight users and groups specified in this assignment.
     */
    public val policyArn: Output<String>?
        get() = javaResource.policyArn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object IamPolicyAssignmentMapper : ResourceMapper<IamPolicyAssignment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.quicksight.IamPolicyAssignment::class == javaResource::class

    override fun map(javaResource: Resource): IamPolicyAssignment = IamPolicyAssignment(
        javaResource
            as com.pulumi.aws.quicksight.IamPolicyAssignment,
    )
}

/**
 * @see [IamPolicyAssignment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IamPolicyAssignment].
 */
public suspend fun iamPolicyAssignment(
    name: String,
    block: suspend IamPolicyAssignmentResourceBuilder.() -> Unit,
): IamPolicyAssignment {
    val builder = IamPolicyAssignmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IamPolicyAssignment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun iamPolicyAssignment(name: String): IamPolicyAssignment {
    val builder = IamPolicyAssignmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
