@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Ingestion].
 */
@PulumiTagMarker
public class IngestionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IngestionArgs = IngestionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IngestionArgsBuilder.() -> Unit) {
        val builder = IngestionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Ingestion {
        val builtJavaResource = com.pulumi.aws.quicksight.Ingestion(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Ingestion(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS QuickSight Ingestion.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Ingestion;
 * import com.pulumi.aws.quicksight.IngestionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Ingestion("example", IngestionArgs.builder()
 *             .dataSetId(aws_quicksight_data_set.example().data_set_id())
 *             .ingestionId("example-id")
 *             .ingestionType("FULL_REFRESH")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import QuickSight Ingestion using the AWS account ID, data set ID, and ingestion ID separated by commas (`,`). For example:
 * ```sh
 *  $ pulumi import aws:quicksight/ingestion:Ingestion example 123456789012,example-dataset-id,example-ingestion-id
 * ```
 *
 */
public class Ingestion internal constructor(
    override val javaResource: com.pulumi.aws.quicksight.Ingestion,
) : KotlinCustomResource(javaResource, IngestionMapper) {
    /**
     * ARN of the Ingestion.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * AWS account ID.
     */
    public val awsAccountId: Output<String>
        get() = javaResource.awsAccountId().applyValue({ args0 -> args0 })

    /**
     * ID of the dataset used in the ingestion.
     */
    public val dataSetId: Output<String>
        get() = javaResource.dataSetId().applyValue({ args0 -> args0 })

    /**
     * ID for the ingestion.
     */
    public val ingestionId: Output<String>
        get() = javaResource.ingestionId().applyValue({ args0 -> args0 })

    /**
     * Ingestion status.
     */
    public val ingestionStatus: Output<String>
        get() = javaResource.ingestionStatus().applyValue({ args0 -> args0 })

    /**
     * Type of ingestion to be created. Valid values are `INCREMENTAL_REFRESH` and `FULL_REFRESH`.
     * The following arguments are optional:
     */
    public val ingestionType: Output<String>
        get() = javaResource.ingestionType().applyValue({ args0 -> args0 })
}

public object IngestionMapper : ResourceMapper<Ingestion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.quicksight.Ingestion::class == javaResource::class

    override fun map(javaResource: Resource): Ingestion = Ingestion(
        javaResource as
            com.pulumi.aws.quicksight.Ingestion,
    )
}

/**
 * @see [Ingestion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Ingestion].
 */
public suspend fun ingestion(name: String, block: suspend IngestionResourceBuilder.() -> Unit):
    Ingestion {
    val builder = IngestionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Ingestion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ingestion(name: String): Ingestion {
    val builder = IngestionResourceBuilder()
    builder.name(name)
    return builder.build()
}
