@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.IngestionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS QuickSight Ingestion.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Ingestion;
 * import com.pulumi.aws.quicksight.IngestionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Ingestion("example", IngestionArgs.builder()
 *             .dataSetId(aws_quicksight_data_set.example().data_set_id())
 *             .ingestionId("example-id")
 *             .ingestionType("FULL_REFRESH")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import QuickSight Ingestion using the AWS account ID, data set ID, and ingestion ID separated by commas (`,`). For example:
 * ```sh
 *  $ pulumi import aws:quicksight/ingestion:Ingestion example 123456789012,example-dataset-id,example-ingestion-id
 * ```
 * @property awsAccountId AWS account ID.
 * @property dataSetId ID of the dataset used in the ingestion.
 * @property ingestionId ID for the ingestion.
 * @property ingestionType Type of ingestion to be created. Valid values are `INCREMENTAL_REFRESH` and `FULL_REFRESH`.
 * The following arguments are optional:
 */
public data class IngestionArgs(
    public val awsAccountId: Output<String>? = null,
    public val dataSetId: Output<String>? = null,
    public val ingestionId: Output<String>? = null,
    public val ingestionType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.IngestionArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.IngestionArgs =
        com.pulumi.aws.quicksight.IngestionArgs.builder()
            .awsAccountId(awsAccountId?.applyValue({ args0 -> args0 }))
            .dataSetId(dataSetId?.applyValue({ args0 -> args0 }))
            .ingestionId(ingestionId?.applyValue({ args0 -> args0 }))
            .ingestionType(ingestionType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IngestionArgs].
 */
@PulumiTagMarker
public class IngestionArgsBuilder internal constructor() {
    private var awsAccountId: Output<String>? = null

    private var dataSetId: Output<String>? = null

    private var ingestionId: Output<String>? = null

    private var ingestionType: Output<String>? = null

    /**
     * @param value AWS account ID.
     */
    @JvmName("twfiaklmlkkqflup")
    public suspend fun awsAccountId(`value`: Output<String>) {
        this.awsAccountId = value
    }

    /**
     * @param value ID of the dataset used in the ingestion.
     */
    @JvmName("cvxkxmhkdbthlfom")
    public suspend fun dataSetId(`value`: Output<String>) {
        this.dataSetId = value
    }

    /**
     * @param value ID for the ingestion.
     */
    @JvmName("cgdvwvqchrvpyhfr")
    public suspend fun ingestionId(`value`: Output<String>) {
        this.ingestionId = value
    }

    /**
     * @param value Type of ingestion to be created. Valid values are `INCREMENTAL_REFRESH` and `FULL_REFRESH`.
     * The following arguments are optional:
     */
    @JvmName("dusvhiifsnquiufl")
    public suspend fun ingestionType(`value`: Output<String>) {
        this.ingestionType = value
    }

    /**
     * @param value AWS account ID.
     */
    @JvmName("lgpvsgnqfsgucpiu")
    public suspend fun awsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsAccountId = mapped
    }

    /**
     * @param value ID of the dataset used in the ingestion.
     */
    @JvmName("ynltsmaborictejo")
    public suspend fun dataSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSetId = mapped
    }

    /**
     * @param value ID for the ingestion.
     */
    @JvmName("seksqwfiqkvfieww")
    public suspend fun ingestionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingestionId = mapped
    }

    /**
     * @param value Type of ingestion to be created. Valid values are `INCREMENTAL_REFRESH` and `FULL_REFRESH`.
     * The following arguments are optional:
     */
    @JvmName("rlyxfxdbyhjoqfin")
    public suspend fun ingestionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingestionType = mapped
    }

    internal fun build(): IngestionArgs = IngestionArgs(
        awsAccountId = awsAccountId,
        dataSetId = dataSetId,
        ingestionId = ingestionId,
        ingestionType = ingestionType,
    )
}
