@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.kotlin.outputs.NamespaceTimeouts
import com.pulumi.aws.quicksight.kotlin.outputs.NamespaceTimeouts.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Namespace].
 */
@PulumiTagMarker
public class NamespaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NamespaceArgs = NamespaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NamespaceArgsBuilder.() -> Unit) {
        val builder = NamespaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Namespace {
        val builtJavaResource = com.pulumi.aws.quicksight.Namespace(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Namespace(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS QuickSight Namespace.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Namespace;
 * import com.pulumi.aws.quicksight.NamespaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Namespace("example", NamespaceArgs.builder()
 *             .namespace("example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import QuickSight Namespace using the AWS account ID and namespace separated by commas (`,`). For example:
 * ```sh
 *  $ pulumi import aws:quicksight/namespace:Namespace example 123456789012,example
 * ```
 *
 */
public class Namespace internal constructor(
    override val javaResource: com.pulumi.aws.quicksight.Namespace,
) : KotlinCustomResource(javaResource, NamespaceMapper) {
    /**
     * ARN of the Namespace.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * AWS account ID.
     */
    public val awsAccountId: Output<String>
        get() = javaResource.awsAccountId().applyValue({ args0 -> args0 })

    /**
     * Namespace AWS Region.
     */
    public val capacityRegion: Output<String>
        get() = javaResource.capacityRegion().applyValue({ args0 -> args0 })

    /**
     * Creation status of the namespace.
     */
    public val creationStatus: Output<String>
        get() = javaResource.creationStatus().applyValue({ args0 -> args0 })

    /**
     * User identity directory type. Defaults to `QUICKSIGHT`, the only current valid value.
     */
    public val identityStore: Output<String>
        get() = javaResource.identityStore().applyValue({ args0 -> args0 })

    /**
     * Name of the namespace.
     * The following arguments are optional:
     */
    public val namespace: Output<String>
        get() = javaResource.namespace().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val timeouts: Output<NamespaceTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })
}

public object NamespaceMapper : ResourceMapper<Namespace> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.quicksight.Namespace::class == javaResource::class

    override fun map(javaResource: Resource): Namespace = Namespace(
        javaResource as
            com.pulumi.aws.quicksight.Namespace,
    )
}

/**
 * @see [Namespace].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Namespace].
 */
public suspend fun namespace(name: String, block: suspend NamespaceResourceBuilder.() -> Unit):
    Namespace {
    val builder = NamespaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Namespace].
 * @param name The _unique_ name of the resulting resource.
 */
public fun namespace(name: String): Namespace {
    val builder = NamespaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
