@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.QuicksightFunctions.getDataSetPlain
import com.pulumi.aws.quicksight.QuicksightFunctions.getQuicksightGroupPlain
import com.pulumi.aws.quicksight.QuicksightFunctions.getQuicksightUserPlain
import com.pulumi.aws.quicksight.QuicksightFunctions.getThemePlain
import com.pulumi.aws.quicksight.kotlin.inputs.GetDataSetColumnLevelPermissionRule
import com.pulumi.aws.quicksight.kotlin.inputs.GetDataSetPlainArgs
import com.pulumi.aws.quicksight.kotlin.inputs.GetDataSetPlainArgsBuilder
import com.pulumi.aws.quicksight.kotlin.inputs.GetQuicksightGroupPlainArgs
import com.pulumi.aws.quicksight.kotlin.inputs.GetQuicksightGroupPlainArgsBuilder
import com.pulumi.aws.quicksight.kotlin.inputs.GetQuicksightUserPlainArgs
import com.pulumi.aws.quicksight.kotlin.inputs.GetQuicksightUserPlainArgsBuilder
import com.pulumi.aws.quicksight.kotlin.inputs.GetThemePlainArgs
import com.pulumi.aws.quicksight.kotlin.inputs.GetThemePlainArgsBuilder
import com.pulumi.aws.quicksight.kotlin.outputs.GetDataSetResult
import com.pulumi.aws.quicksight.kotlin.outputs.GetQuicksightGroupResult
import com.pulumi.aws.quicksight.kotlin.outputs.GetQuicksightUserResult
import com.pulumi.aws.quicksight.kotlin.outputs.GetThemeResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.quicksight.kotlin.outputs.GetDataSetResult.Companion.toKotlin as getDataSetResultToKotlin
import com.pulumi.aws.quicksight.kotlin.outputs.GetQuicksightGroupResult.Companion.toKotlin as getQuicksightGroupResultToKotlin
import com.pulumi.aws.quicksight.kotlin.outputs.GetQuicksightUserResult.Companion.toKotlin as getQuicksightUserResultToKotlin
import com.pulumi.aws.quicksight.kotlin.outputs.GetThemeResult.Companion.toKotlin as getThemeResultToKotlin

public object QuicksightFunctions {
    /**
     * Data source for managing a QuickSight Data Set.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.quicksight.QuicksightFunctions;
     * import com.pulumi.aws.quicksight.inputs.GetDataSetArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = QuicksightFunctions.getDataSet(GetDataSetArgs.builder()
     *             .dataSetId("example-id")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getDataSet.
     * @return A collection of values returned by getDataSet.
     */
    public suspend fun getDataSet(argument: GetDataSetPlainArgs): GetDataSetResult =
        getDataSetResultToKotlin(getDataSetPlain(argument.toJava()).await())

    /**
     * @see [getDataSet].
     * @param awsAccountId AWS account ID.
     * @param columnLevelPermissionRules
     * @param dataSetId Identifier for the data set.
     * The following arguments are optional:
     * @param tags
     * @param tagsAll
     * @return A collection of values returned by getDataSet.
     */
    public suspend fun getDataSet(
        awsAccountId: String? = null,
        columnLevelPermissionRules: List<GetDataSetColumnLevelPermissionRule>? = null,
        dataSetId: String,
        tags: Map<String, String>? = null,
        tagsAll: Map<String, String>? = null,
    ): GetDataSetResult {
        val argument = GetDataSetPlainArgs(
            awsAccountId = awsAccountId,
            columnLevelPermissionRules = columnLevelPermissionRules,
            dataSetId = dataSetId,
            tags = tags,
            tagsAll = tagsAll,
        )
        return getDataSetResultToKotlin(getDataSetPlain(argument.toJava()).await())
    }

    /**
     * @see [getDataSet].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;quicksight&#46;kotlin&#46;inputs&#46;GetDataSetPlainArgs].
     * @return A collection of values returned by getDataSet.
     */
    public suspend fun getDataSet(argument: suspend GetDataSetPlainArgsBuilder.() -> Unit):
        GetDataSetResult {
        val builder = GetDataSetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDataSetResultToKotlin(getDataSetPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source can be used to fetch information about a specific
     * QuickSight group. By using this data source, you can reference QuickSight group
     * properties without having to hard code ARNs or unique IDs as input.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.quicksight.QuicksightFunctions;
     * import com.pulumi.aws.quicksight.inputs.GetQuicksightGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = QuicksightFunctions.getQuicksightGroup(GetQuicksightGroupArgs.builder()
     *             .groupName("example")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getQuicksightGroup.
     * @return A collection of values returned by getQuicksightGroup.
     */
    public suspend fun getQuicksightGroup(argument: GetQuicksightGroupPlainArgs):
        GetQuicksightGroupResult =
        getQuicksightGroupResultToKotlin(getQuicksightGroupPlain(argument.toJava()).await())

    /**
     * @see [getQuicksightGroup].
     * @param awsAccountId AWS account ID.
     * @param groupName The name of the group that you want to match.
     * The following arguments are optional:
     * @param namespace QuickSight namespace. Defaults to `default`.
     * @return A collection of values returned by getQuicksightGroup.
     */
    public suspend fun getQuicksightGroup(
        awsAccountId: String? = null,
        groupName: String,
        namespace: String? = null,
    ): GetQuicksightGroupResult {
        val argument = GetQuicksightGroupPlainArgs(
            awsAccountId = awsAccountId,
            groupName = groupName,
            namespace = namespace,
        )
        return getQuicksightGroupResultToKotlin(getQuicksightGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getQuicksightGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;quicksight&#46;kotlin&#46;inputs&#46;GetQuicksightGroupPlainArgs].
     * @return A collection of values returned by getQuicksightGroup.
     */
    public suspend
    fun getQuicksightGroup(argument: suspend GetQuicksightGroupPlainArgsBuilder.() -> Unit):
        GetQuicksightGroupResult {
        val builder = GetQuicksightGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getQuicksightGroupResultToKotlin(getQuicksightGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source can be used to fetch information about a specific
     * QuickSight user. By using this data source, you can reference QuickSight user
     * properties without having to hard code ARNs or unique IDs as input.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.quicksight.QuicksightFunctions;
     * import com.pulumi.aws.quicksight.inputs.GetQuicksightUserArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = QuicksightFunctions.getQuicksightUser(GetQuicksightUserArgs.builder()
     *             .userName("example")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getQuicksightUser.
     * @return A collection of values returned by getQuicksightUser.
     */
    public suspend fun getQuicksightUser(argument: GetQuicksightUserPlainArgs):
        GetQuicksightUserResult =
        getQuicksightUserResultToKotlin(getQuicksightUserPlain(argument.toJava()).await())

    /**
     * @see [getQuicksightUser].
     * @param awsAccountId AWS account ID.
     * @param namespace QuickSight namespace. Defaults to `default`.
     * @param userName The name of the user that you want to match.
     * The following arguments are optional:
     * @return A collection of values returned by getQuicksightUser.
     */
    public suspend fun getQuicksightUser(
        awsAccountId: String? = null,
        namespace: String? = null,
        userName: String,
    ): GetQuicksightUserResult {
        val argument = GetQuicksightUserPlainArgs(
            awsAccountId = awsAccountId,
            namespace = namespace,
            userName = userName,
        )
        return getQuicksightUserResultToKotlin(getQuicksightUserPlain(argument.toJava()).await())
    }

    /**
     * @see [getQuicksightUser].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;quicksight&#46;kotlin&#46;inputs&#46;GetQuicksightUserPlainArgs].
     * @return A collection of values returned by getQuicksightUser.
     */
    public suspend
    fun getQuicksightUser(argument: suspend GetQuicksightUserPlainArgsBuilder.() -> Unit):
        GetQuicksightUserResult {
        val builder = GetQuicksightUserPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getQuicksightUserResultToKotlin(getQuicksightUserPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS QuickSight Theme.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.quicksight.QuicksightFunctions;
     * import com.pulumi.aws.quicksight.inputs.GetThemeArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = QuicksightFunctions.getTheme(GetThemeArgs.builder()
     *             .themeId("example")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getTheme.
     * @return A collection of values returned by getTheme.
     */
    public suspend fun getTheme(argument: GetThemePlainArgs): GetThemeResult =
        getThemeResultToKotlin(getThemePlain(argument.toJava()).await())

    /**
     * @see [getTheme].
     * @param awsAccountId AWS account ID.
     * @param tags A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * @param themeId Identifier of the theme.
     * The following arguments are optional:
     * @return A collection of values returned by getTheme.
     */
    public suspend fun getTheme(
        awsAccountId: String? = null,
        tags: Map<String, String>? = null,
        themeId: String,
    ): GetThemeResult {
        val argument = GetThemePlainArgs(
            awsAccountId = awsAccountId,
            tags = tags,
            themeId = themeId,
        )
        return getThemeResultToKotlin(getThemePlain(argument.toJava()).await())
    }

    /**
     * @see [getTheme].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;quicksight&#46;kotlin&#46;inputs&#46;GetThemePlainArgs].
     * @return A collection of values returned by getTheme.
     */
    public suspend fun getTheme(argument: suspend GetThemePlainArgsBuilder.() -> Unit):
        GetThemeResult {
        val builder = GetThemePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getThemeResultToKotlin(getThemePlain(builtArgument.toJava()).await())
    }
}
