@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.kotlin.outputs.RefreshScheduleSchedule
import com.pulumi.aws.quicksight.kotlin.outputs.RefreshScheduleSchedule.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RefreshSchedule].
 */
@PulumiTagMarker
public class RefreshScheduleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RefreshScheduleArgs = RefreshScheduleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RefreshScheduleArgsBuilder.() -> Unit) {
        val builder = RefreshScheduleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RefreshSchedule {
        val builtJavaResource = com.pulumi.aws.quicksight.RefreshSchedule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RefreshSchedule(builtJavaResource)
    }
}

/**
 * Resource for managing a QuickSight Refresh Schedule.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.RefreshSchedule;
 * import com.pulumi.aws.quicksight.RefreshScheduleArgs;
 * import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleArgs;
 * import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleScheduleFrequencyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RefreshSchedule("example", RefreshScheduleArgs.builder()
 *             .dataSetId("dataset-id")
 *             .schedule(RefreshScheduleScheduleArgs.builder()
 *                 .refreshType("FULL_REFRESH")
 *                 .scheduleFrequency(RefreshScheduleScheduleScheduleFrequencyArgs.builder()
 *                     .interval("HOURLY")
 *                     .build())
 *                 .build())
 *             .scheduleId("schedule-id")
 *             .build());
 *     }
 * }
 * ```
 * ### With Weekly Refresh
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.RefreshSchedule;
 * import com.pulumi.aws.quicksight.RefreshScheduleArgs;
 * import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleArgs;
 * import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleScheduleFrequencyArgs;
 * import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RefreshSchedule("example", RefreshScheduleArgs.builder()
 *             .dataSetId("dataset-id")
 *             .schedule(RefreshScheduleScheduleArgs.builder()
 *                 .refreshType("INCREMENTAL_REFRESH")
 *                 .scheduleFrequency(RefreshScheduleScheduleScheduleFrequencyArgs.builder()
 *                     .interval("WEEKLY")
 *                     .refreshOnDay(RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs.builder()
 *                         .dayOfWeek("MONDAY")
 *                         .build())
 *                     .timeOfTheDay("01:00")
 *                     .timezone("Europe/London")
 *                     .build())
 *                 .build())
 *             .scheduleId("schedule-id")
 *             .build());
 *     }
 * }
 * ```
 * ### With Monthly Refresh
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.RefreshSchedule;
 * import com.pulumi.aws.quicksight.RefreshScheduleArgs;
 * import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleArgs;
 * import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleScheduleFrequencyArgs;
 * import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RefreshSchedule("example", RefreshScheduleArgs.builder()
 *             .dataSetId("dataset-id")
 *             .schedule(RefreshScheduleScheduleArgs.builder()
 *                 .refreshType("INCREMENTAL_REFRESH")
 *                 .scheduleFrequency(RefreshScheduleScheduleScheduleFrequencyArgs.builder()
 *                     .interval("MONTHLY")
 *                     .refreshOnDay(RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs.builder()
 *                         .dayOfMonth("1")
 *                         .build())
 *                     .timeOfTheDay("01:00")
 *                     .timezone("Europe/London")
 *                     .build())
 *                 .build())
 *             .scheduleId("schedule-id")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import a QuickSight Refresh Schedule using the AWS account ID, data set ID and schedule ID separated by commas (`,`). For example:
 * ```sh
 *  $ pulumi import aws:quicksight/refreshSchedule:RefreshSchedule example 123456789012,dataset-id,schedule-id
 * ```
 *
 */
public class RefreshSchedule internal constructor(
    override val javaResource: com.pulumi.aws.quicksight.RefreshSchedule,
) : KotlinCustomResource(javaResource, RefreshScheduleMapper) {
    /**
     * Amazon Resource Name (ARN) of the refresh schedule.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * AWS account ID.
     */
    public val awsAccountId: Output<String>
        get() = javaResource.awsAccountId().applyValue({ args0 -> args0 })

    /**
     * The ID of the dataset.
     */
    public val dataSetId: Output<String>
        get() = javaResource.dataSetId().applyValue({ args0 -> args0 })

    /**
     * The [refresh schedule](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RefreshSchedule.html). See schedule
     * The following arguments are optional:
     */
    public val schedule: Output<RefreshScheduleSchedule>?
        get() = javaResource.schedule().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The ID of the refresh schedule.
     */
    public val scheduleId: Output<String>
        get() = javaResource.scheduleId().applyValue({ args0 -> args0 })
}

public object RefreshScheduleMapper : ResourceMapper<RefreshSchedule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.quicksight.RefreshSchedule::class == javaResource::class

    override fun map(javaResource: Resource): RefreshSchedule = RefreshSchedule(
        javaResource as
            com.pulumi.aws.quicksight.RefreshSchedule,
    )
}

/**
 * @see [RefreshSchedule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RefreshSchedule].
 */
public suspend fun refreshSchedule(
    name: String,
    block: suspend RefreshScheduleResourceBuilder.() -> Unit,
): RefreshSchedule {
    val builder = RefreshScheduleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RefreshSchedule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun refreshSchedule(name: String): RefreshSchedule {
    val builder = RefreshScheduleResourceBuilder()
    builder.name(name)
    return builder.build()
}
